using System;
using System.Collections.Generic;
using System.Text;

namespace CFW.common.tableCommand
{
    /// <summary>
    /// e[uփf[^XVR}h
    /// </summary>
    public class TableUpdateCommand : TableCommand
    {
        /// <summary>
        /// e[uփf[^XVR}h
        /// </summary>
        /// <param name="tname"></param>
        public TableUpdateCommand(string tname) : base(tname)
        {

        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override string BuildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("UPDATE " + TableName + " SET " + Environment.NewLine);
            int c = 0;
            for (int i = 0; i < Columns.Count; i++)
            {
                TableCommandColumn col = Columns[i];

                if (c > 0) b.Append(",");
                b.Append(" " + col.ColumnName + " = " + col.Expression + Environment.NewLine);

                c++;

            }
            b.Append(" WHERE ");
            for (int i = 0; i < Conditions.Count; i++)
            {
                TableCommandCondition cond = Conditions[i];
                b.Append(" " + cond.BuildCondition() + Environment.NewLine);

            }


            return b.ToString();
        }
    }
}
