using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;
using OFW.FieldProperties;

namespace OFW.Database.TableCommand
{
    /// <summary>
    /// e[u폜R}h
    /// </summary>
    public class TableDeleteCommand : TableCommand
    {
        /// <summary>
        /// 폜e[u
        /// </summary>
        public string TableName;
        /// <summary>
        /// 
        /// </summary>
        public List<TableCommandCondition> Where;

        /// <summary>
        /// e[u폜R}h
        /// </summary>
        public TableDeleteCommand(string tname)
            
        {
            this.TableName = tname;
            this.Where = new List<TableCommandCondition>();
            this.Command = new Command();

        }
        /// <summary>
        /// WHEREǉ ftHgAND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhere(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// WHEREǉ AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereAnd(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// WHEREǉ OR
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereOr(TableCommandCondition condition)
        {


            if (this.Where.Count > 0) condition.ConditionOperator = "OR";
            this.Where.Add(condition);
        }

        /// <summary>
        /// SQL
        /// </summary>
        public override void BuildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("DELETE FROM " + TableName +  Environment.NewLine);

            if (Where.Count > 0)
            {
                b.Append(" WHERE ");
                for (int i = 0; i < Where.Count; i++)
                {
                    TableCommandCondition cond = Where[i];
                    if (!string.IsNullOrEmpty(cond.ConditionOperator)) b.Append(" " + cond.ConditionOperator + " ");
                    b.Append(" " + cond.BuildCondition() + Environment.NewLine);

                }
            }

            this.Command.Text = b.ToString();
        }


        /// <summary>
        /// p[^\z
        /// </summary>
        public override void BuildParameters()
        {
            if (Command == null) BuildCommand();
            //XṼp[^ݒ
            for (int i = 0; i < this.Where.Count; i++)
            {
                TableCommandCondition cond = this.Where[i];
                List<Parameter> paramList = cond.GetParameters();
                for (int j = 0; j < paramList.Count; j++)
                {
                    Parameter p = paramList[j];

                    Parameter param = new Parameter(p);
                    Command.SetParameter(param);
                }

            }
            return;
        }
    }
}
