using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;

namespace OFW.Database.TableCommand
{
    /// <summary>
    /// e[uI
    /// </summary>
    public class PagedSelectCommand : TableSelectCommand
    {
        int offset;

        /// <summary>
        /// Jnʒu(1)
        /// </summary>
        public int Offset
        {
            get { return offset; }
            set { offset = value; }
        }
        int limit;
        /// <summary>
        /// 擾
        /// </summary>
        public int Limit
        {
            get { return limit; }
            set { limit = value; }
        }


        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        public PagedSelectCommand() : base()
        {
        }
        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        /// <param name="tableName"></param>
        /// 
        public PagedSelectCommand(string tableName) : base(tableName)
        {
        }
        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        public PagedSelectCommand(string tableName, string alias) : base(tableName,alias)
        {
        }
        /// <summary>
        /// p[^
        /// </summary>
        public override void BuildParameters()
        {
            //IɃp[^nƂ͕s\
            //̃p[^ݒ
            for (int i = 0; i < this.Where.Count; i++)
            {
                TableCommandCondition cond = this.Where[i];
                List<Parameter> plist = cond.GetParameters();
                for (int j = 0; j < plist.Count; j++)
                {
                    Parameter p = plist[j];

                    Parameter param = new Parameter(p);
                    Command.Parameters.Add(param);
                }

            }
            return;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void BuildQuery()
        {
            int start = offset;
            int last = offset + limit - 1;

            StringBuilder b = new StringBuilder();
            string orderBy = BuildOrderBy();

            //NG[
            b.Append("SELECT TOP " + last.ToString());
            if (this.Modifier != "")
            {
                b.Append(this.Modifier);
            }
            b.Append(Environment.NewLine);
            if (this.SelectColumns.Count == 0)
            {
                b.Append("*");
            }
            else
            {
                b.Append(BuildSelectList());
            }
            b.Append(string.Format(" FROM {0} ", this.TableName));
            if (this.Where.Count > 0)
            {
                b.Append(" WHERE ");
                b.Append(BuildWhere());

            }
            if (this.OrderBy.Count > 0)
            {
                b.Append(" ORDER BY ");
                b.Append(orderBy);
            }
            if (this.GroupBy.Count > 0)
            {
                b.Append(" GROUP BY");
                b.Append(BuildGroupBy());
            }
            if (this.Having.Count > 0)
            {
                b.Append(" HAVING ");
                b.Append(BuildHaving());
            }

            StringBuilder outer = new StringBuilder();
            outer.Append("SELECT TOP " + limit.ToString() + " * ");
            outer.Append(" FROM (");
            outer.Append(b.ToString());
            outer.Append(" ) as inner_table ");
            if (this.OrderBy.Count > 0)
            {
                outer.Append(" ORDER BY ");
                outer.Append(BuildReverseOrderBy().Replace(".","__"));
            }

            string q = string.Format("SELECT * FROM ( {0} ) as outer_table order by {1}", outer.ToString(), orderBy.Replace(".","__"));



            this.Command.Text = q;
        }
        /// <summary>
        ///  \z
        /// </summary>
        /// <returns></returns>
        public string BuildReverseOrderBy()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.OrderBy.Count; i++)
            {
                if (i > 0) b.Append(",");
                TableCommandColumn col = this.OrderBy[i];
                string[] elements = col.Expression.Split(' ');
                if (elements.Length == 1)
                {
                    b.Append(" " + elements[0] + " DESC " + Environment.NewLine);
                }
                else
                {
                    b.Append(" " + elements[0] + (elements[1] == "ASC" ? " DESC " : " ASC ") + Environment.NewLine);
                }

            }
            return b.ToString();
        }
    }
}
