using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using System.Reflection;
using OFW.Models;
using OFW.FieldProperties;
using OFW.Log;

namespace OFW.Database.SqlServer
{
    /// <summary>
    /// SQLServerɐڑ
    /// </summary>
    public class SqlServerConnection : Connection
    {
        /// <summary>
        /// Oo
        /// </summary>
        private OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);

        static string privateKey = "craftsql";
        private SqlConnection connection;
        private SqlTransaction transaction;
        /// <summary>
        /// ڑJ
        /// </summary>
        /// <param name="isolation"></param>
        /// <param name="beginTransaction"></param>
        protected override void OpenInternal(IsolationLevel isolation, bool beginTransaction)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                this.connection = new SqlConnection(BuildConnectionString());
                this.isolation = isolation;//TODO:ftHgisolation̕ۑƕ
                connection.Open();
                if (beginTransaction)
                {
                    this.BeginTransaction(this.isolation);
                }
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="commitTransaction"></param>
        protected override void CloseInternal(bool commitTransaction)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                if (this.connection != null)
                {
                    if (this.transaction != null)
                    {
                        if (commitTransaction)
                        {
                            this.CommitTransaction();
                        }
                        else
                        {
                            this.RollbackTransaction();
                        }
                    }
                    this.connection.Close();
                    this.connection = null;
                }

            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        /// <summary>
        /// ڑ\z
        /// </summary>
        /// <remarks>[U[ƃpX[hEncryptStringExɂĈÍĂO</remarks>
        /// <returns>ڑ</returns>
        protected string BuildConnectionString()
        {

            SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder();

            if (this.config.EncryptUser)
            {
                OFW.Util.Crypt crypt = new OFW.Util.Crypt();
                builder.UserID = crypt.DecryptStringEx(this.config.User, privateKey);
                builder.Password = crypt.DecryptStringEx(this.config.Password, privateKey);
            }
            else
            {
                builder.UserID = this.config.User;
                builder.Password = this.config.Password;
            }
            if (this.config.Url.StartsWith("file:"))
            {
                builder.AttachDBFilename = this.config.Url.Substring(5);
                builder.DataSource = ".\\SQLEXPRESS";
                builder.UserInstance = true;
                builder.IntegratedSecurity = true;
            }
            else
            {
                builder.DataSource = this.config.Url;
            }
            builder.ConnectTimeout = this.config.ConnectionTimeout;
            builder.InitialCatalog = this.config.Database;
            builder.PersistSecurityInfo = true;
            string connectionString = builder.ConnectionString;
            if (this.config.Option != "")
            {
                connectionString += ";" + this.config.Option;
            }
            return connectionString;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="isolation"></param>
        protected override void BeginTransactionInternal(IsolationLevel isolation)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                // ݂̐ڑgUNV擾Ă
                this.transaction = this.connection.BeginTransaction(isolation);
            }
            catch (InvalidOperationException ioex)
            {

                OFW.ErrorHandler.ErrorMessageBuilder handler = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex, this.currentUser);
                handler.WriteLog();
                // gUNV̓T|[gĂ܂B
                throw ioex;
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        protected override void CommitTransactionInternal()
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                if (this.transaction != null)
                {
                    this.transaction.Commit();
                }
            }
            catch (InvalidOperationException ioex)
            {
                OFW.ErrorHandler.ErrorMessageBuilder handler = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ioex, this.currentUser);
                handler.WriteLog();
                // gUNV́AɃR~bg܂̓[obNĂ܂B
                // ܂́AڑؒfĂ܂
                throw ioex;
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                this.transaction = null;		// gpς݂ƂĂ
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        protected override void RollbackTransactionInternal()
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            try
            {
                if (this.transaction != null)
                {
                    this.transaction.Rollback();
                    //rollbackAp͂Ȃ̂ō폜Ă
                    this.transaction = null;
                }
            }
            catch (DbException dbex)
            {
                throw this.BuildException(dbex, null);
            }
            finally
            {
                this.transaction = null;		// gpς݂ƂĂ
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        /// <summary>
        /// ǂݎ悤f[^A_v^[
        /// </summary>
        /// <returns></returns>
        protected override DbDataAdapter CreateDataAdapter()
        {
            SqlDataAdapter da =  new SqlDataAdapter();
            return da;
        }
        /// <summary>
        /// R}h(System.Data.Common.DbCommand)𐶐
        /// </summary>
        /// <param name="command">ɂȂOFW.Database.Command</param>
        /// <returns>R}h</returns>
        protected override DbCommand CreateDbCommand(Command command)
        {
            SqlCommand actCommand = new SqlCommand(command.Text, this.connection, this.transaction);
            actCommand.CommandType = command.CommandType;
            foreach (Parameter p in command.Parameters)
            {
                SqlParameter param = actCommand.CreateParameter();
                param.ParameterName = p.ParameterName;
                param.DbType = p.ParameterType;
                param.Value = FixValue(p.ParameterValue);
                if ((p.ParameterType == DbType.String) || (p.ParameterType == DbType.StringFixedLength))
                {
                    
                    if (p.Precision == 0)
                    {
                        if (p.Length == 0)
                        {
                            string v = (string)p.ParameterValue;
                            if (string.IsNullOrEmpty(v))
                            {
                                param.Size = 4000;
                            }
                            else
                            {
                                param.Size = v.Length;
                            }
                        }
                        else
                        {
                            param.Size = p.Length;
                        }
                    }
                    else
                    {
                        param.Size = p.Precision;
                    }
                }
                else
                {
                    param.Size = p.Length;
                    param.Precision = (byte)p.Precision;
                    param.Scale = (byte)p.Scale;
                }

                param.Direction = p.ParameterDirection;
                actCommand.Parameters.Add(param);

            }
            return actCommand;
        }

        /// <summary>
        /// VXeԎ擾
        /// </summary>
        /// <returns></returns>
        public override DateTime SystemDate()
        {
            //̃NG[AR}hƂ͕ʂ̐ڑgpB
            SqlConnection con = new SqlConnection(this.BuildConnectionString());
            try
            {
                con.Open();
                string q = "SELECT convert(datetime, getdate())";
                SqlCommand command = con.CreateCommand();
                command.CommandText = q;
                command.Connection = con;
                object d = command.ExecuteScalar();

                //X댯...܂null͂肦ȂB
                return (DateTime)d;
            }
            finally
            {
                con.Close();
            }
        }
        /// <summary>
        /// e[u̍\𒲂ׂ
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public override IEntityProperty DescribeTable(string tableName)
        {
            DataSet columnInfo = this.GetColumnInfo(tableName);
            DataSet primaryKeys = this.GetPrimaryKeys(tableName);
            DataSet comments = this.GetColumnComments(tableName);

            if (columnInfo.Tables[0].Rows.Count == 0) return null;

            DefaultTableProperties property = new DefaultTableProperties();
            foreach (DataRow row in columnInfo.Tables[0].Rows)
            {
                FieldProperty p = FieldProperty.NewInstance(row);
                if (p != null)
                {
                    property.fieldList.Add(p);
                }
            }
            foreach (DataRow row in primaryKeys.Tables[0].Rows)
            {
                string fld = row["COLUMN_NAME"].ToString();
                foreach (FieldProperty p in property.Fields())
                {
                    if (p.FieldName == fld)
                    {
                        p.IsPrimaryKey = true;
                        break;
                    }
                }
            }
            foreach (DataRow row in comments.Tables[0].Rows)
            {
                string fld = row["objname"].ToString();
                foreach (FieldProperty p in property.Fields())
                {
                    if (p.FieldName == fld)
                    {
                        p.DisplayName = row["value"].ToString();
                        break;
                    }
                }
            }

            property.EntityName = tableName;
            return property;
        }
        /// <summary>
        /// e[u\擾
        /// TODO:
        /// </summary>
        /// <param name="tableName">e[u</param>
        /// <returns>e[u\</returns>
        public override DataSet ListTables(string tableName)
        {
            Command command = new Command("select * from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME LIKE @tableName AND TABLE_SCHEMA = @schema" , CommandType.Text);
            command.SetParameter(new Parameter("@tableName", DbType.String, tableName));
            command.SetParameter(new Parameter("@schema", DbType.String, "dbo"));

            return ExecuteQuery(command);
        }

        /// <summary>
        /// ŌID
        /// </summary>
        /// <returns></returns>
        public override int GetLastIdentity()
        {
            string q = "select @@identity";


            SqlCommand command = this.connection.CreateCommand();
            command.CommandText = q;
            command.Connection = this.connection;
            command.Transaction = this.transaction;

            object id = command.ExecuteScalar();

            return OFW.Util.NumberUtil.IntValue( id );
        }

        #region IDisposable o
        /// <summary>
        /// Dispose
        /// 
        /// ڑĂȂꍇAgUNVjĐڑB
        /// (web serviceœ삷ꍇlB)
        /// </summary>
        public override void Dispose()
        {
            logger.Log(LogLevel.DEBUG, null, System.Reflection.MethodInfo.GetCurrentMethod().Name, " disposed");
            
            if (this.connection != null)
            {
                this.Close(false);
                this.connection = null;
            }
        }

        #endregion

        /// <summary>
        /// SQLT[o[pڑȎgݗ
        /// </summary>
        /// <param name="ex">DBO</param>
        /// <param name="commands">command</param>
        /// <returns>VڑO</returns>
        protected override ConnectionException BuildException(DbException ex,params Command[] commands)
        {
            SqlException sqlException = (SqlException)ex;
            ConnectionException newException = new ConnectionException(sqlException.Message,
                sqlException.Number,
                sqlException.State,
                sqlException.Server,
                sqlException.Procedure,
                sqlException.LineNumber,
                commands
            );

            return newException;
        }
    }
}
