using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Text;
using CFW.FieldProperties;
using CFW.Database.Conditions;

namespace CFW.Database
{
    /// <summary>
    /// 쐬H
    /// </summary>
    public class ConditionFactory
    {
        Connection context;
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="contextConnection">쐬ɎgڑBp[^̌`Ap̌`AʎqpLȂǂ肷</param>
        public ConditionFactory(Connection contextConnection)
        {
            context = contextConnection;
        }
        /// <summary>
        ///  = (@) ̌`̏쐬
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="value">rl</param>
        /// <returns></returns>
        public Condition create(string columnName, object value)
        {
            return new ColumnValueCondition(columnName, context.buildParameterName(columnName),value, "=");
        }
        /// <summary>
        ///  = (@) ̌`̏쐬
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="value">rl</param>
        /// <param name="op">Zq</param>
        /// <returns></returns>
        public Condition create(string columnName, object value, string op)
        {
            return new ColumnValueCondition(columnName, context.buildParameterName(columnName),value, op);
        }
        /// <summary>
        ///  = (@) ̌`̏쐬
        /// <p>string  IEnumerableĂ邽߃I[o[[hsɂȂ̂h</p>
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="value">rl</param>
        /// <param name="op">Zq</param>
        /// <returns></returns>
        public Condition create(string columnName, string value, string op)
        {
            return new ColumnValueCondition(columnName, context.buildParameterName(columnName),value, op);
        }
        /// <summary>
        ///  op (@_0,@_1,@_2, ...) `̏쐬B IN  BETWEEN
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="values">rl</param>
        /// <param name="op">Zq(IN,NOT IN,BETWEEN etc...)</param>
        /// <returns></returns>
        public Condition create(string columnName, IEnumerable values, string op)
        {
            return new ColumnValueCondition(columnName, context.buildParameterName(columnName), values, op);
        }
        /// <summary>
        ///  op @parameteName `̏쐬
        /// <p>Ώۂ̐ڑɍp[^`parameterNameB</p>
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="parameterName">p[^BڑŊ肳`ŏƁBSqlServer "@"tAODP":"tAȂǁB</param>
        /// <param name="value">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(string columnName,string parameterName, object value, string op)
        {
            return new ColumnValueCondition(columnName, parameterName, value, op);
        }
        /// <summary>
        ///  op @parameteName `̏쐬
        /// <p>Ώۂ̐ڑɍp[^`parameterNameB</p>
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="parameterName">p[^BڑŊ肳`ŏƁBSqlServer "@"tAODP":"tAȂǁB</param>
        /// <param name="value">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(string columnName, string parameterName, string value, string op)
        {
            return new ColumnValueCondition(columnName, parameterName, value, op);
        }
        /// <summary>
        ///  op @parameteName `̏쐬
        /// <p>Ώۂ̐ڑɍp[^`parameterNameB</p>
        /// </summary>
        /// <param name="columnName"></param>
        /// <param name="parameterName">p[^BڑŊ肳`ŏƁBSqlServer "@"tAODP":"tAȂǁB</param>
        /// <param name="values">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(string columnName, string parameterName, IEnumerable values, string op)
        {
            return new ColumnValueCondition(columnName, parameterName, values, op);
        }
        /// <summary>
        ///  = (@) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="value">rl</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, object value)
        {
            return new ColumnValueCondition(columnSpec, context.buildParameterName(columnSpec.Alias()), value, "=");
        }
        /// <summary>
        ///  op (@) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="value">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, object value, string op)
        {
            return new ColumnValueCondition(columnSpec, context.buildParameterName(columnSpec.Alias()), value, op);
        }
        /// <summary>
        ///  op (@) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="value">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, string value, string op)
        {
            return new ColumnValueCondition(columnSpec, context.buildParameterName(columnSpec.Alias()), value, op);
        }
        /// <summary>
        ///  op (@) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="values">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, IEnumerable values, string op)
        {
            return new ColumnValueCondition(columnSpec, context.buildParameterName(columnSpec.Alias()), values, op);
        }
        /// <summary>
        ///  op (@parameterName) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="parameterName">p[^</param>
        /// <param name="value">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, string parameterName, object value, string op)
        {
            return new ColumnValueCondition(columnSpec, parameterName, value, op);
        }
        /// <summary>
        ///  op (@parameterName) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="parameterName">p[^</param>
        /// <param name="value">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, string parameterName, string value, string op)
        {
            return new ColumnValueCondition(columnSpec, parameterName, value, op);
        }
        /// <summary>
        ///  op (@parameterName) `̏쐬
        /// </summary>
        /// <param name="columnSpec"></param>
        /// <param name="parameterName">p[^</param>
        /// <param name="values">rl</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty columnSpec, string parameterName, IEnumerable values, string op)
        {
            return new ColumnValueCondition(columnSpec, parameterName, values, op);
        }
        /// <summary>
        /// w肵ɂB
        /// </summary>
        /// <param name="exp">Lq</param>
        /// <param name="parameters">Ήp[^</param>
        /// <returns></returns>
        public Condition create(string exp, params Parameter[] parameters)
        {
            return new StringCondition(exp, parameters);
        }
        /// <summary>
        /// w肵ɂB
        /// </summary>
        /// <param name="exp">Lq</param>
        /// <param name="parameters">Ήp[^</param>
        /// <returns></returns>
        public Condition create(string exp, IEnumerable<Parameter> parameters)
        {
            return new StringCondition(exp, parameters);
        }
        /// <summary>
        /// ̗r ("="Œ) 
        /// </summary>
        /// <param name="left">̗</param>
        /// <param name="right">E̗</param>
        /// <returns></returns>
        public Condition create(FieldProperty left, FieldProperty right)
        {
            return new RelationCondition(left, right, "=");
        }
        /// <summary>
        /// ̗r
        /// </summary>
        /// <param name="left">̗</param>
        /// <param name="right">E̗</param>
        /// <param name="op">rZq</param>
        /// <returns></returns>
        public Condition create(FieldProperty left, FieldProperty right, string op)
        {
            return new RelationCondition(left, right, op);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="conditions"></param>
        /// <returns></returns>
        public ComplexCondition complex(params Condition[] conditions)
        {
            ComplexCondition complexCondition = new ComplexCondition();
            foreach (Condition condition in conditions)
            {
                complexCondition.AddCondition("AND", condition);
            }
            return complexCondition;
        }
    }
}
