using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Database.Expressions;

namespace OFW.Database.CommandBuilder
{
    /// <summary>
    /// e[uf[^XVR}h
    /// </summary>
    public class UpdateCommandBuilder : CommandBuilderBase
    {
        /// <summary>
        /// e[u
        /// </summary>
        private string targetTable;
        /// <summary>
        /// J
        /// </summary>
        private StringBuilder columnsBuilder;

        #region constructors
        /// <summary>
        /// e[uփf[^ǉR}h
        /// </summary>
        public UpdateCommandBuilder(Connection connection)
            : base()
        {
            this.connection = connection;

            columnsBuilder = new StringBuilder();
            targetTable = "";

        }
        /// <summary>
        /// XVΏۃe[uw肷
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public UpdateCommandBuilder table(string tableName)
        {
            targetTable = tableName;
            return this;
        }
        #endregion
        /// <summary>
        /// 
        /// </summary>
        /// <param name="property"></param>
        /// <param name="value"></param>
        public UpdateCommandBuilder update(FieldProperties.FieldProperty property, object value)
        {
            if (columnsBuilder.Length > 0) columnsBuilder.Append(",");

            columnsBuilder.Append(connection.QuoteIdentifier(property.FieldName));
            columnsBuilder.Append(" = ");

            string parameterName = connection.buildParameterName(property.FieldName);
            columnsBuilder.Append(parameterName);

            Parameter param = new Parameter(parameterName, property.SqlType(), value);
            param.Length = property.Length;
            param.Precision = property.Precision;
            param.Scale = property.Scale;

            parameters.Add(param);

            return this;

        }

        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public UpdateCommandBuilder where(Expression cond)
        {
            criteria.AddWhere(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public UpdateCommandBuilder whereAnd(Expression cond)
        {
            criteria.AddWhereAnd(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public UpdateCommandBuilder whereOr(Expression cond)
        {
            criteria.AddWhereOr(cond);
            return this;
        }

        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void buildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("UPDATE " + targetTable );
            b.Append(" SET " + columnsBuilder.ToString() + " ");

            if (criteria.whereExpression != "")
            {
                b.Append(" WHERE " + criteria.whereExpression);
            }


            query = b.ToString();
        }

    }
}
