using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Models;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Database.Expressions;
namespace OFW.Database.CommandBuilder
{
    /// <summary>
    /// ING[gݗ
    /// </summary>
    /// <example>
    /// g(SĂ̗I)BIʂ̗񖼂͌̃e[û܂܂ƂȂB
    /// <code>
    /// ConditionFactory cf = currentConnection.getConditionFactory();
    /// SelectCommandBuilder builder = new SelectCommandBuilder(currentConnection);
    /// //select()ĂяoȂƑSĂ̗IB񖼂͌̃e[û܂܂ƂȂB
    /// builder.from("BASE_TABLE")
    ///     .joinLeft("MAST_CODE","SELECTABLE_NAME1",
    ///         cf.create("BASE_TABLE.CODE1 = SELECTABLE_NAME1.CODE"),
    ///         cf.create("SELECTABLE_NAME1.DELETE_FLAG = 0")
    ///     )
    ///     .joinLeft("MAST_CODE","SELECTABLE_NAME2",
    ///         conditionFactory.create("BASE_TABLE.CODE1 = SELECTABLE_NAME2.CODE"),
    ///         conditionFactory.create("SELECTABLE_NAME2.DELETE_FLAG = 0")
    ///     )
    ///     .where(cf.create(&quot;BASE_TABLE.DELETE_FLAG = 0&quot;))
    ///     .where(cf.create(&quot;BASE_TABLE.FROM_DATE&quot;,&quot;@d1&quot;,new DateTime(),&quot;&lt;=&quot;))
    ///     .where(cf.create(&quot;BASE_TABLE.FROM_DATE&quot;,&quot;@d2&quot;,DateUtil.Parse(&quot;2010/1/1&quot;),&quot;&gt;=&quot;))
    ///     .orderBy("BASE_TABLE.COLUMN1");
    /// DataSet result = builder.getCommand().ExecuteQuery(currentConnection);
    /// 
    /// </code>
    /// g(I𖾎)
    /// <code>
    /// ConditionFactory cf = currentConnection.getConditionFactory();
    /// SelectCommandBuilder builder = new SelectCommandBuilder(currentConnection);
    /// builder.from("BASE_TABLE")
    ///     .joinLeft("MAST_CODE","SELECTABLE_NAME1",
    ///         cf.create("BASE_TABLE.CODE1 = SELECTABLE_NAME1.CODE"),
    ///         cf.create("SELECTABLE_NAME1.DELETE_FLAG = 0")
    ///     )
    ///     .joinLeft("MAST_CODE","SELECTABLE_NAME2",
    ///         conditionFactory.create("BASE_TABLE.CODE2 = SELECTABLE_NAME2.CODE"),
    ///         conditionFactory.create("SELECTABLE_NAME2.DELETE_FLAG = 0")
    ///     )
    ///     .select("BASE_TABLE.COLUMN1","C1")
    ///     .select("BASE_TABLE.COLUMN2","C2")
    ///     .select("BASE_TABLE.COLUMN3","C3")
    ///     .select("BASE_TABLE.COLUMN4","C4")
    ///     .select("BASE_TABLE.COLUMN5","C5")
    ///     .select("BASE_TABLE.COLUMN6","C6")
    ///     .where(cf.create(&quot;BASE_TABLE.DELETE_FLAG = 0&quot;))
    ///     .where(cf.create(&quot;BASE_TABLE.FROM_DATE&quot;,&quot;@d1&quot;,new DateTime(),&quot;&lt;=&quot;))
    ///     .where(cf.create(&quot;BASE_TABLE.FROM_DATE&quot;,&quot;@d2&quot;,DateUtil.Parse(&quot;2010/1/1&quot;),&quot;&gt;=&quot;))
    ///     .orderBy("BASE_TABLE.COLUMN1");
    /// DataSet result = builder.getCommand().ExecuteQuery(currentConnection);
    /// 
    /// </code>
    /// g(EntityPropertygđSĂ̗I)BIʂ̗񖼂̓GeBeBvpeBœGCAX(ʏe[uʖ+"__" + )ƂȂB
    /// <code>
    /// BaseEntityProperty baseEntityProperty = new BaseEntityProperty();
    /// MastCodeProperty selectableName1Property = new MastCodeProperty();
    /// selectableName1Property.Alias = "SELECTABLE_NAME1";
    /// MastCodeProperty selectableName2Property = new MastCodeProperty();
    /// selectableName2Property.Alias = "SELECTABLE_NAME2";
    ///
    /// ConditionFactory cf = currentConnection.getConditionFactory();
    /// SelectCommandBuilder builder = new SelectCommandBuilder(currentConnection);
    /// builder.from(baseEntityProperty)
    ///     .joinLeft(selectableName1Property,
    ///         cf.create(baseEntityProperty.Code1,selectableName1Property.Code),
    ///         cf.create(selectableName1Property,0)
    ///     )
    ///     .joinLeft(selectableName2Property,
    ///         cf.create(baseEntityProperty.Code2,selectableName2Property.Code),
    ///         cf.create(selectableName2Property,0)
    ///     )
    ///     .select(baseEntityProperty.Fields())
    ///     .select(selectableName1Property.Fields())
    ///     .select(selectableName2Property.Fields())
    ///     .where(cf.create(baseEntityProperty,0))
    ///     .where(cf.create(baseEntityProperty.fromDate,&quot;@d1&quot;,new DateTime(),&quot;&lt;=&quot;))
    ///     .where(cf.create(baseEntityProperty.fromDate,&quot;@d2&quot;,DateUtil.Parse(&quot;2010/1/1&quot;),&quot;&gt;=&quot;))
    ///     .orderBy(baseEntityProperty.Column1);
    /// DataSet result = builder.getCommand().ExecuteQuery(currentConnection);
    /// 
    /// </code>
    /// <remarks>ING[gݗāB</remarks>
    /// </example>
    public class SelectCommandBuilder : CommandBuilderBase
    {
        StringBuilder joinBuilder;
        StringBuilder selectListBuilder;
        string selectOptions;
        /// <summary>
        /// dOIvV
        /// </summary>
        public const string OPTION_DISTINCT = "distinct";
        List<string> fromTables;
        /// <summary>
        /// \z
        /// </summary>
        public SelectCommandBuilder()
            : base()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            joinBuilder = new StringBuilder();
            selectListBuilder = new StringBuilder();

            selectOptions = "";
            fromTables = new List<string>();
        }
        
        /// <summary>
        /// \z
        /// </summary>
        public SelectCommandBuilder(Connection connection) : base()
        {
            this.connection = connection;
            joinBuilder = new StringBuilder();
            selectListBuilder = new StringBuilder();

            selectOptions = "";
            fromTables = new List<string>();
        }
        /// <summary>
        /// FROMݒ
        /// </summary>
        /// <param name="tableName"></param>
        public SelectCommandBuilder from(string tableName)
        {
            joinInternal("",tableName,"");
            return this;
        }
        /// <summary>
        /// FROMݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        public SelectCommandBuilder from(string tableName, string alias)
        {
            joinInternal("", tableName, alias);
            fromTables.Add(alias);
            return this;
        }
        /// <summary>
        /// FROMݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        public SelectCommandBuilder from(EntityProperty tableProperty)
        {
            joinInternal("",connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema,tableProperty.EntityName), tableProperty.Alias);

            return this;
        }
        /// <summary>
        /// FROMݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="alias"></param>
        public SelectCommandBuilder from(EntityProperty tableProperty,string alias)
        {
            joinInternal("", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), alias);

            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder join(string tableName, params Expression[] conditions)
        {
            joinInternal("INNER JOIN",tableName, "", conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder join(string tableName, string alias, params Expression[] conditions)
        {
            joinInternal("INNER JOIN", tableName, alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinLeft(string tableName, params Expression[] conditions)
        {
            joinInternal("LEFT JOIN", tableName, "", conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinLeft(string tableName, string alias, params Expression[] conditions)
        {
            joinInternal("LEFT JOIN", tableName, alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinRight(string tableName, params Expression[] conditions)
        {
            joinInternal("RIGHT JOIN", tableName, "", conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinRight(string tableName, string alias, params Expression[] conditions)
        {
            joinInternal("RIGHT JOIN", tableName, alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder join(EntityProperty tableProperty, params Expression[] conditions)
        {
            joinInternal("INNER JOIN", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), tableProperty.Alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder join(EntityProperty tableProperty, string alias, params Expression[] conditions)
        {
            joinInternal("INNER JOIN", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinLeft(EntityProperty tableProperty, params Expression[] conditions)
        {
            joinInternal("LEFT JOIN", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), tableProperty.Alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinLeft(EntityProperty tableProperty, string alias, params Expression[] conditions)
        {
            joinInternal("LEFT JOIN", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinRight(EntityProperty tableProperty, params Expression[] conditions)
        {
            joinInternal("RIGHT JOIN", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), tableProperty.Alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="tableProperty"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        public SelectCommandBuilder joinRight(EntityProperty tableProperty, string alias, params Expression[] conditions)
        {
            joinInternal("RIGHT JOIN", connection.QuoteTableName(tableProperty.Catalog, tableProperty.Schema, tableProperty.EntityName), alias, conditions);
            return this;
        }
        /// <summary>
        /// JOINe[uݒ
        /// </summary>
        /// <param name="joinType"></param>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        /// <param name="conditions"></param>
        private void joinInternal(string joinType, string tableName, string alias, params Expression[] conditions)
        {
            if (joinType != ""){
                joinBuilder.Append(" "); 
                joinBuilder.Append(joinType + " ");
            }
            joinBuilder.Append(tableName);

            if (alias != "")
            {
                joinBuilder.Append(" " + alias);
                fromTables.Add(alias);
            }
            else
            {
                fromTables.Add(tableName);
            }
            if (conditions != null)
            {
                if (conditions.Length > 0)
                {
                    joinBuilder.Append(" ON ");
                    int i = 0;
                    foreach (Expression c in conditions)
                    {
                        c.buildExpression();
                        if (i > 0) joinBuilder.Append(" AND ");
                        joinBuilder.Append(c.getExpression());

                        parameters.AddRange(c.getParameters());
                        i++;
                    }
                }
            }
        }
        /// <summary>
        /// dOꍇ
        /// </summary>
        /// <returns></returns>
        public SelectCommandBuilder distinct()
        {
            selectOptions += OPTION_DISTINCT;
            return this;
        }
        /// <summary>
        /// I𕶂ɃIvVt(DISTINCTȂ)
        /// </summary>
        /// <param name="option">DISTINCSTȂǂ̕BTOP n w肵Ăocriteria.limitgB</param>
        /// <returns></returns>
        public SelectCommandBuilder option(string option)
        {
            if (selectOptions.Length > 0) selectOptions += " ";
            selectOptions += option;
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        public SelectCommandBuilder select(string column)
        {
            selectInternal(column, "");
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="columns"></param>
        public SelectCommandBuilder select(IEnumerable<string> columns)
        {
            foreach (string c in columns)
            {
                selectInternal(c, "");
            }
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        /// <param name="alias"></param>
        public SelectCommandBuilder select(string column, string alias)
        {
            selectInternal(column, connection.QuoteIdentifier(alias));
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        public SelectCommandBuilder select(FieldProperty column)
        {
            selectInternal(connection.QuoteColumnName(column.TableName, column.FieldName), connection.QuoteIdentifier(column.Alias()));
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        /// <param name="alias"></param>
        public SelectCommandBuilder select(FieldProperty column,string alias)
        {
            selectInternal(connection.QuoteColumnName(column.TableName, column.FieldName), connection.QuoteIdentifier(alias));
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="columns"></param>
        public SelectCommandBuilder select(IEnumerable<FieldProperty> columns)
        {
            foreach (FieldProperty c in columns)
            {
                selectInternal(connection.QuoteColumnName(c.TableName, c.FieldName), connection.QuoteIdentifier(c.Alias()));
            }
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        /// <param name="alias"></param>
        private void selectInternal(string column, string alias)
        {
            if (selectListBuilder.Length > 0) selectListBuilder.Append(",");
            selectListBuilder.Append(column);
            if (alias != "")
            {
                selectListBuilder.Append(" AS " + alias);
            }
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public SelectCommandBuilder where(Expression cond)
        {
            criteria.where(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public SelectCommandBuilder whereAnd(Expression cond)
        {
            criteria.whereAnd(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(WHERE)
        /// </summary>
        /// <param name="cond"></param>
        public SelectCommandBuilder whereOr(Expression cond)
        {
            criteria.whereOr(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(HAVING)
        /// </summary>
        /// <param name="cond"></param>
        public SelectCommandBuilder having(Expression cond)
        {
            criteria.having(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(HAVING)
        /// </summary>
        /// <param name="cond"></param>
        public SelectCommandBuilder havingAnd(Expression cond)
        {
            criteria.havingAnd(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(HAVING)
        /// </summary>
        /// <param name="cond"></param>
        public SelectCommandBuilder havingOr(Expression cond)
        {
            criteria.havingOr(cond);
            return this;
        }
        /// <summary>
        /// Iݒ(GROUP BY)
        /// </summary>
        /// <param name="column"></param>
        public SelectCommandBuilder groupBy(string column)
        {
            criteria.groupBy(column);
            return this;
        }
        /// <summary>
        /// Iݒ(GROUP BY)
        /// </summary>
        /// <param name="column"></param>
        public SelectCommandBuilder groupBy(FieldProperty column)
        {
            criteria.groupBy(connection.QuoteColumnName( column.TableName,column.FieldName ));
            return this;
        }
        /// <summary>
        /// Iݒ(ORDER BY)
        /// </summary>
        /// <param name="column"></param>
        public SelectCommandBuilder orderBy(string column)
        {
            criteria.AddOrderBy(column,"ASC");
            return this;
        }
        /// <summary>
        /// Iݒ(ORDER BY)
        /// </summary>
        /// <param name="column"></param>
        /// <param name="direction"></param>
        public SelectCommandBuilder orderBy(string column, string direction)
        {
            criteria.AddOrderBy(column, direction);
            return this;
        }
        /// <summary>
        /// Iݒ(ORDER BY)
        /// </summary>
        /// <param name="column"></param>
        public SelectCommandBuilder orderBy(FieldProperty column)
        {
            criteria.AddOrderBy(connection.QuoteColumnName(column.TableName, column.FieldName), "ASC");
            return this;
        }
        /// <summary>
        /// Iݒ(ORDER BY)
        /// </summary>
        /// <param name="column"></param>
        /// <param name="direction"></param>
        public SelectCommandBuilder orderBy(FieldProperty column, string direction)
        {
            criteria.AddOrderBy(connection.QuoteColumnName(column.TableName, column.FieldName), direction);
            return this;
        }
        /// <summary>
        /// 擾ݒ
        /// </summary>
        /// <remarks>offsetƑgݍ킹paginates</remarks>
        /// <param name="n"></param>
        public SelectCommandBuilder limit(int n)
        {
            criteria.limit = n;
            return this;
        }
        /// <summary>
        /// 擾Jnʒuݒ
        /// </summary>
        /// <param name="n"></param>
        public SelectCommandBuilder offset(int n)
        {
            criteria.offset = n;
            return this;
        }
        /// <summary>
        /// NG[gݗ
        /// </summary>
        override public void buildQuery()
        {
            bool doPaginate = false;
            if (criteria.offset >= 0) doPaginate = true;

            int start = criteria.offset + 1;
            int end = criteria.offset + criteria.limit;

            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.Append("SELECT");
            if (!string.IsNullOrEmpty(selectOptions))
            {
                queryBuilder.Append(" ");
                queryBuilder.Append(selectOptions);
            }
            if (connection.supportsTop())
            {
                if ((criteria.limit > 0) )
                {
                    if (doPaginate)
                    {
                        queryBuilder.Append(string.Format(" ROW_NUMBER() OVER(ORDER BY {0}) AS ___rownum, ",criteria.orderByExpression));
                    }
                    else
                    {
                        queryBuilder.Append(" TOP " + criteria.limit.ToString());
                    }
                }
            }
            queryBuilder.Append(" ");
            if (selectListBuilder.Length == 0)
            {
                foreach (string alias in fromTables)
                {
                    if (selectListBuilder.Length > 0)
                    {
                        selectListBuilder.Append(",");
                    }
                    selectListBuilder.Append(alias + ".*");
                }
            }
            queryBuilder.Append(selectListBuilder.ToString());
            queryBuilder.Append(" FROM ");
            queryBuilder.Append(joinBuilder.ToString());

            if (criteria.whereExpression != "")
            {
                queryBuilder.Append(" WHERE ");
                queryBuilder.Append(criteria.whereExpression);
            }

            if (criteria.groupByExpression != "")
            {
                queryBuilder.Append(" GROUP BY ");
                queryBuilder.Append(criteria.groupByExpression);
            }
            if (criteria.havingExpression != "")
            {
                queryBuilder.Append(" HAVING ");
                queryBuilder.Append(criteria.havingExpression);
            }
            if (criteria.orderByExpression != "")
            {
                if (connection.supportsTop() && doPaginate)
                {
                }
                else
                {
                    queryBuilder.Append(" ORDER BY ");
                    queryBuilder.Append(criteria.orderByExpression);
                }
            }
            if (connection.supportsLimit())
            {
                if (criteria.limit > 0)
                {
                    if (doPaginate)
                    {
                        queryBuilder.Append(" LIMIT " + criteria.offset.ToString() + "," + criteria.limit.ToString());
                    }
                    else
                    {
                        queryBuilder.Append(" LIMIT "  + criteria.limit.ToString());
                    }
                }
            }


            if (connection.supportsTop() && doPaginate)
            {
                string paginateQuery = "select * from( {0} ) as ordered where ___rownum between {1} and {2} order by {3}";
                query = string.Format(paginateQuery, queryBuilder.ToString(), start, end, criteria.orderByExpression.Replace(".","__"));
            }
            else
            {
                query = queryBuilder.ToString();
            }

        }
    }
}
