using System;
using System.Collections.Generic;
using System.Text;
using OFW.Forms;
using OFW.Forms.Filters;
using OFW.Util;
using OFW.Auth.Model;
using OFW.Auth.Model.TableRow;
using OFW.Auth.Model.TableProperty;
using OFW.Auth.Model.TableValidator;


namespace OFW.Auth.Model.TableFormAdapter
{
    /// <summary>
    /// table auth_users Field`
    /// </summary>
    public class AuthUsersTableFormAdapter : OFW.Forms.FormAdapter
	{
		private AuthUsersTableRow table;

		///<summary>[login_id]</summary>
		public FormAdapterElement LoginId;
		///<summary>[name]</summary>
		public FormAdapterElement Name;
		///<summary>[password]</summary>
		public FormAdapterElement Password;
		///<summary>[description]</summary>
		public FormAdapterElement Description;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override OFW.Models.Entity GetEntity()
        {
            return this.table;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			this.LoginId.Render();
			this.Name.Render();
			this.Password.Render();
			this.Description.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="entity">̃A_v^[f[^</param>
        public override void SetEntity(OFW.Models.Entity entity)
        {
        	this.table = (AuthUsersTableRow)entity;
			this.LoginId.SetValue(this.table.LoginId);
			this.Name.SetValue(this.table.Name);
			this.Password.SetValue(this.table.Password);
			this.Description.SetValue(this.table.Description);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			this.table.LoginId = StringUtil.StringValue(this.LoginId.GetValue());
			this.table.Name = StringUtil.StringValue(this.Name.GetValue());
			this.table.Password = StringUtil.StringValue(this.Password.GetValue());
			this.table.Description = StringUtil.StringValue(this.Description.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			this.LoginId.UpdateField();
			this.Name.UpdateField();
			this.Password.UpdateField();
			this.Description.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			if(!this.LoginId.Validate()){
				valid = false;
				this.messages.Add(this.LoginId.ErrorMessage);
			}
			if(!this.Name.Validate()){
				valid = false;
				this.messages.Add(this.Name.ErrorMessage);
			}
			if(!this.Password.Validate()){
				valid = false;
				this.messages.Add(this.Password.ErrorMessage);
			}
			if(!this.Description.Validate()){
				valid = false;
				this.messages.Add(this.Description.ErrorMessage);
			}
			

            return valid;
        }
		
	}

}