using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;

namespace OFW.Acl.Models 
{
    /// <summary>
    /// AclRules f`
    /// </summary>
    [Serializable()]
	public class AclRulesModel : DbModel<AclRulesEntity,AclRulesProperty>
	{
        /// <summary>
        /// default construct  
        /// </summary>
        public AclRulesModel() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public AclRulesModel(Connection connection) : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public AclRulesModel(Connection connection, AclRulesProperty property) : base(connection,property)
        {
        }
        string message;
        /// <summary>
        /// DAsʂ̃bZ[W
        /// </summary>
        public string Message
        {
            get { return this.message; }
        }
        /// <summary>
        /// w胊\[XIDɐݒ肳郋[SĎ擾
        /// </summary>
        /// <param name="resourceId">T[Ɋ֘A郊\[XID</param>
        /// <returns>w胊\[XIDɐݒ肳郋[</returns>
        public List<IAclRule> GetRulesByResourceId(int resourceId)
        {
            List<IAclRule> rules = new List<IAclRule>();
            try
            {
                this.connect();
                string query = @"select 
acl_rules.*,
acl_resources.name as resource_name,
acl_roles.name as role_name
from 
acl_rules
inner join acl_resources
on acl_rules.resource_id = acl_resources.id
inner join acl_roles
on acl_rules.role_id = acl_roles.id

where acl_rules.resource_id = @resource_id
and acl_rules.deleted = 0
";

                Command command = new Command(query, System.Data.CommandType.Text);
                command.SetParameter(new Parameter("@resource_id", DbType.Int32, resourceId));
                using (DataSet result = connection.ExecuteQuery(command))
                {
                    foreach (DataRow row in result.Tables[0].Rows)
                    {
                        AclRulesEntity rule = new AclRulesEntity();
                        rule.Map(row);
                        rules.Add(rule);

                    }
                }

                return rules;
            }
            finally
            {
                try
                {
                    this.disconnect();
                }
                catch (Exception)
                {

                    throw;
                }
            }



        }
        /// <summary>
        /// SẴXg
        /// </summary>
        /// <returns>[</returns>
        public List<AclRulesEntity> GetAllRules()
        {
            List<AclRulesEntity> rules = new List<AclRulesEntity>();
            try
            {
                this.connect();
                string query = @"select 
acl_rules.*,
acl_resources.name as resource_name,
acl_roles.name as role_name

from 
acl_rules
inner join acl_resources
on acl_rules.resource_id = acl_resources.id
inner join acl_roles
on acl_rules.role_id = acl_roles.id
where acl_rules.deleted = 0
";

                Command command = new Command(query, System.Data.CommandType.Text);
                using (DataSet result = connection.ExecuteQuery(command))
                {
                    foreach (DataRow row in result.Tables[0].Rows)
                    {
                        AclRulesEntity rule = new AclRulesEntity();
                        rule.Map(row);
                        rules.Add(rule);

                    }
                }

                return rules;
            }
            finally
            {
                try
                {
                    this.disconnect();
                }
                catch (Exception)
                {

                    throw;
                }
            }



        }
        /// <summary>
        /// V[ID
        /// </summary>
        /// <returns>V[ID</returns>
        public int NewId()
        {
            string query = @"
select isnull( max(id), 0) + 1
from 
acl_rules
";

            Command command = new Command(query, System.Data.CommandType.Text);
            int newId = (int)connection.ExecuteScalar(command);
            return newId;

        }
        /// <summary>
        /// \[XID ƃ[IDv郋[IDTB
        /// </summary>
        /// <param name="resourceId">Ώۃ\[XID</param>
        /// <param name="roleId">Ώۃ[ID</param>
        /// <returns>[IDAȂ0</returns>
        public int GetId(int resourceId, int roleId)
        {
            string query = @"
select id
from 
acl_rules
where resource_id = @resource_id
and role_id = @role_id
";

            Command command = new Command(query, System.Data.CommandType.Text);
            command.SetParameter(new Parameter("@resource_id", DbType.Int32, resourceId));
            command.SetParameter(new Parameter("@role_id", DbType.Int32, roleId));

            DataSet result = connection.ExecuteQuery(command);
            int id = 0;
            if (result.Tables[0].Rows.Count > 0)
            {
                id = OFW.Util.NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            }

            return id;
        }
        /// <summary>
        /// ҏWς݃[ۑ
        /// </summary>
        /// <param name="rule">Ώۃ[</param>
        /// <returns>1ȏA0͎̎s</returns>
        public override int save(AclRulesEntity rule)
        {
            try
            {
                this.connect();
                DataSource<AclRulesEntity> datasource = new DataSource<AclRulesEntity>();
                datasource.setConnection(connection);
                AclRulesProperty property = new AclRulesProperty();
                datasource.setProperty(property);

                int result = 0;

                if (rule.IsDeleted)
                {
                    rule.deleted = 1;
                    rule.IsDeleted = false;
                    result = datasource.save(rule);
                    rule.IsDeleted = true;
                }
                else
                {
                    if (rule.roleId == 0)
                    {
                        Models.AclRolesModel rolesModel = new Models.AclRolesModel();
                        IAclRole role = rolesModel.findByName(rule.roleName);
                        if (role == null)
                        {
                            this.message = "Ώۃ[܂B[mFĂB";
                            return 0;
                        }
                        rule.roleId = role.id;
                    }
                    int id = this.GetId(rule.resourceId, rule.roleId);

                    if (id > 0)
                    {
                        rule.id = id;
                        rule.IsModified = true;
                        rule.IsNew = false;
                        result = datasource.save(rule);
                    }
                    else
                    {
                        rule.id = this.NewId();
                        rule.IsModified = true;
                        rule.IsNew = true;

                        result = datasource.save(rule);
                    }
                }

                return result;
            }
            finally
            {
                try
                {
                    this.disconnect();
                }
                catch (Exception)
                {

                    throw;
                }
            }



        }

	}

}