using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Database;
using OFW.Util;

namespace OFW.Acl
{
    /// <summary>
    /// DBɃf[^ACL̎
    /// </summary>
    public class DbAcl : AccessControl
    {
        Connection connection;
        bool aclDataLoaded;
        /// <summary>
        /// \z
        /// </summary>
        public DbAcl() : base()
        {
            aclDataLoaded = false;
        }

        /// <summary>
        /// w胍[Ώۃ\[X錠`FbN
        /// </summary>
        /// <param name="resourceName">Ώۃ\[X</param>
        /// <param name="privilege">`FbNBSĂȂAclPrivilege.All</param>
        /// <param name="roles">[wBw肷B</param>
        /// <returns>True</returns>
        public override bool IsAllowed(string resourceName, AclPrivilege privilege, IEnumerable<IAclRole> roles)
        {
            try
            {
                if(!aclDataLoaded) loadAclData();

                return base.IsAllowed(resourceName, privilege, roles);

            }
            finally
            {
            }
        }
        void loadAclData()
        {
            try
            {
                this.OpenConnection();

                if (this.roleIndex.Count == 0) this.LoadRoles();
                if (this.resourceIndex.Count == 0) this.LoadResources();
                if (this.rules.Count == 0) this.LoadRules();

                aclDataLoaded = true;

            }
            finally
            {
                this.CloseConnection();
            }
        }
        void OpenConnection()
        {
            if (this.connection == null)
            {
                this.connection = ConnectionFactory.GetConnectionByName(config.Connection);
            }
            this.connection.Open();
        }
        void CloseConnection()
        {
            this.connection.Close();
            this.connection = null;
        }
        void LoadRules()
        {
            Models.AclRulesModel moodel = new OFW.Acl.Models.AclRulesModel(this.connection);
            this.rules = new List<IAclRule>();
            List<OFW.Acl.Models.AclRulesEntity> allRules = moodel.GetAllRules();
            foreach (OFW.Acl.Models.AclRulesEntity entity in allRules)
            {
                this.rules.Add(entity);
            }

        }
        void LoadResources()
        {
            Models.AclResourcesModel model = new OFW.Acl.Models.AclResourcesModel(this.connection);
            

            List<OFW.Acl.Models.AclResourcesEntity> allResource = model.findAll();
            foreach (OFW.Acl.Models.AclResourcesEntity entity in allResource)
            {
                IAclResource parent = FindResourceByName(entity.parentName);
                parent.appendChild(entity);
                resourceIndex.Add(entity.name, entity);
            }

        }
        void LoadRoles()
        {
            Models.AclRolesModel model = new Models.AclRolesModel(this.connection);
            List<OFW.Acl.Models.AclRolesEntity> allRoles = model.findAll();
            foreach (OFW.Acl.Models.AclRolesEntity entity in allRoles)
            {
                IAclRole parent = FindRoleByName(entity.parentName);
                parent.appendChild(entity);
                roleIndex.Add(entity.name, entity);
            }

        }
        /// <summary>
        /// [U[ɕRt[擾
        /// </summary>
        /// <param name="loginId">[U[ʂID</param>
        /// <returns>[U[ɕRt[</returns>
        public override List<IAclRole> GetRolesByUser(string loginId)
        {
            try
            {
                OpenConnection();
                Models.AclRolesModel model = new OFW.Acl.Models.AclRolesModel(this.connection);
                return model.findByUser(loginId);

            }
            catch (Exception)
            {

                throw;
            }
            finally
            {
                CloseConnection();
            }


        }
    }
}
