/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.ImplicitResultChecker;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    SequenceIterator currentIterator;
    int last = -1;
    SequenceReceiver currentReceiver;
    boolean isTemporaryDestination = false;
    XPathContext caller = null;
    protected StackFrame stackFrame;
    Object origin = null;

    protected XPathContextMinor() {
    }

    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext(this);
    }

    public XPathContextMinor newMinorContext() {
        XPathContextMinor xPathContextMinor = new XPathContextMinor();
        xPathContextMinor.controller = this.controller;
        xPathContextMinor.caller = this;
        xPathContextMinor.currentIterator = this.currentIterator;
        xPathContextMinor.currentReceiver = this.currentReceiver;
        xPathContextMinor.last = this.last;
        xPathContextMinor.isTemporaryDestination = this.isTemporaryDestination;
        xPathContextMinor.stackFrame = this.stackFrame;
        return xPathContextMinor;
    }

    public void setCaller(XPathContext xPathContext) {
        this.caller = xPathContext;
    }

    public XPathContextMajor newCleanContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.getController());
        xPathContextMajor.setCaller(this);
        return xPathContextMajor;
    }

    public XPathContextMajor.XSLTContext getXSLTContext() {
        return this.getCaller().getXSLTContext();
    }

    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    public void setOrigin(InstructionInfoProvider instructionInfoProvider) {
        this.origin = instructionInfoProvider;
    }

    public void setOriginatingConstructType(int n) {
        this.origin = new Integer(n);
    }

    public int getOriginatingConstructType() {
        if (this.origin instanceof InstructionInfoProvider) {
            return ((InstructionInfoProvider)this.origin).getInstructionInfo().getConstructType();
        }
        return (Integer)this.origin;
    }

    public InstructionInfoProvider getOrigin() {
        if (this.origin instanceof InstructionInfoProvider) {
            return (InstructionInfoProvider)this.origin;
        }
        return null;
    }

    public final Controller getController() {
        return this.controller;
    }

    public final Configuration getConfiguration() {
        return this.controller.getConfiguration();
    }

    public final NamePool getNamePool() {
        return this.controller.getNamePool();
    }

    public final NameChecker getNameChecker() {
        return this.controller.getConfiguration().getNameChecker();
    }

    public final XPathContext getCaller() {
        return this.caller;
    }

    public void setCurrentIterator(SequenceIterator sequenceIterator) {
        this.currentIterator = sequenceIterator;
        this.last = 0;
    }

    public final SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public final int getContextPosition() throws DynamicError {
        if (this.currentIterator == null) {
            DynamicError dynamicError = new DynamicError("The context position is currently undefined");
            dynamicError.setXPathContext(this);
            dynamicError.setErrorCode("FONC0001");
            throw dynamicError;
        }
        return this.currentIterator.position();
    }

    public final Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public final int getLast() throws XPathException {
        if (this.last > 0) {
            return this.last;
        }
        if (this.currentIterator == null) {
            DynamicError dynamicError = new DynamicError("The context size is currently undefined");
            dynamicError.setXPathContext(this);
            dynamicError.setErrorCode("FONC0001");
            throw dynamicError;
        }
        if ((this.currentIterator.getProperties() & 2) == 0) {
            SequenceIterator sequenceIterator = this.currentIterator.getAnother();
            this.last = 0;
            while (sequenceIterator.next() != null) {
                ++this.last;
            }
            return this.last;
        }
        this.last = ((LastPositionFinder)this.currentIterator).getLastPosition();
        return this.last;
    }

    public final boolean isAtLast() throws XPathException {
        if ((this.currentIterator.getProperties() & 4) != 0) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.getContextPosition() == this.getLast();
    }

    public final StringCollator getCollation(String string) throws XPathException {
        Serializable serializable;
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator stringCollator = null;
        if (this.controller != null && (stringCollator = this.controller.getExecutable().getNamedCollation(string)) == null) {
            serializable = this.controller.getConfiguration();
            stringCollator = ((Configuration)serializable).getCollationURIResolver().resolve(string, null, (Configuration)serializable);
        }
        if (stringCollator == null) {
            serializable = new DynamicError("Unknown collation " + string);
            ((XPathException)serializable).setErrorCode("FOCH0002");
            ((DynamicError)serializable).setXPathContext(this);
            throw serializable;
        }
        return stringCollator;
    }

    public final StringCollator getDefaultCollation() {
        if (this.controller != null) {
            return this.controller.getExecutable().getDefaultCollation();
        }
        return CodepointCollator.getInstance();
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public ValueRepresentation evaluateLocalVariable(int n) {
        return this.stackFrame.slots[n];
    }

    public void setLocalVariable(int n, ValueRepresentation valueRepresentation) {
        this.stackFrame.slots[n] = valueRepresentation;
    }

    public void changeOutputDestination(Properties properties, Result result, boolean bl, int n, int n2, SchemaType schemaType) throws XPathException {
        if (bl && this.isTemporaryDestination) {
            DynamicError dynamicError = new DynamicError("Cannot switch to a final result destination while writing a temporary tree");
            dynamicError.setErrorCode("XTDE1480");
            throw dynamicError;
        }
        if (bl) {
            n2 |= 0x10000;
        } else {
            this.isTemporaryDestination = true;
        }
        PipelineConfiguration pipelineConfiguration = null;
        if (result instanceof Receiver) {
            pipelineConfiguration = ((Receiver)result).getPipelineConfiguration();
        }
        if (pipelineConfiguration == null) {
            pipelineConfiguration = this.controller.makePipelineConfiguration();
            pipelineConfiguration.setSerializing(bl);
            pipelineConfiguration.setHostLanguage(n);
        }
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setHostLanguage(n);
        complexContentOutputter.setPipelineConfiguration(pipelineConfiguration);
        if (properties == null) {
            properties = new Properties();
        }
        SerializerFactory serializerFactory = this.getConfiguration().getSerializerFactory();
        Receiver receiver = serializerFactory.getReceiver(result, pipelineConfiguration, properties);
        if ("yes".equals(properties.getProperty("{http://saxon.sf.net/}implicit-result-document"))) {
            receiver = new ImplicitResultChecker(receiver, this.controller);
        }
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
        receiver = this.controller.getConfiguration().getDocumentValidator(namespaceReducer, receiver.getSystemId(), n2, 10, schemaType);
        complexContentOutputter.setReceiver(receiver);
        this.currentReceiver = complexContentOutputter;
    }

    public void setTemporaryReceiver(SequenceReceiver sequenceReceiver) {
        this.isTemporaryDestination = true;
        this.currentReceiver = sequenceReceiver;
    }

    public void setReceiver(SequenceReceiver sequenceReceiver) {
        this.currentReceiver = sequenceReceiver;
    }

    public final SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    public boolean useLocalParameter(int n, LocalParam localParam, boolean bl) throws XPathException {
        return this.getCaller().useLocalParameter(n, localParam, bl);
    }

    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    public Rule getCurrentTemplateRule() {
        return this.getCaller().getCurrentTemplateRule();
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    public final int getImplicitTimezone() {
        return this.getConfiguration().getImplicitTimezone();
    }
}

