package jp.sourceforge.ocmml.android.modulators;

import java.nio.DoubleBuffer;

import jp.sourceforge.ocmml.android.Sample;

public abstract class Modulator {
    protected static final int TABLE_LENGTH = 1 << 16;
    protected static final int PHASE_SHIFT = 14;
    protected static final int PHASE_HALF = TABLE_LENGTH << (PHASE_SHIFT - 1);
    public static final int PHASE_LENGTH = TABLE_LENGTH << PHASE_SHIFT;
    protected static final int PHASE_MASK = PHASE_LENGTH - 1;

    protected Modulator() {
        resetPhase();
        setFrequency(Sample.FREQUENCY_BASE);
    }

    public void addPhase(int time) {
        mPhase = (mPhase + mFrequencyShift * time) & PHASE_MASK;
    }

    public void resetPhase() {
        mPhase = 0;
    }

    public void getSamples(DoubleBuffer samples, int start, int end) {
        for (int i = start; i < end; i++)
            samples.put(i, getNextSample());
    }

    public double getFrequency() {
        return mFrequency;
    }

    public void setFrequency(double value) {
        mFrequency = value;
        mFrequencyShift = (int) (value * (PHASE_LENGTH / Sample.RATE));
    }

    public abstract double getNextSample();

    public abstract double getNextSampleOfs(int ofs);

    protected double mFrequency;
    protected int mFrequencyShift;
    protected int mPhase;
}
