/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
//  TestMMLEvent.m
//  OCMML
//
//  Created by hkrn on 09/03/01.
//  Copyright 2009 hkrn. All rights reserved.
//
//  $Id: TestMMLEvent.m 65 2009-04-25 12:07:49Z hikarin $
//

#import "TestMMLEvent.h"

@implementation TestMMLEvent

- (void)setUp
{
    event = [[MMLEvent alloc] init];
}

- (void)tearDown
{
    [event release];
}

- (void)testSettingEot
{
    [event setEOT];
    STAssertEquals(event.status, kMMLEventEot, @"");
}

- (void)testEnablingNote
{
    [event enableNoteWithNumber:1 velocity:2];
    STAssertEquals(event.status, kMMLEventNoteOn, @"");
    STAssertEquals(event.noteNumber, 1, @"");
    STAssertEquals(event.velocity, 2, @"");
}

- (void)testDisablingNote
{
    [event disableNoteWithNumber:3 velocity:4];
    STAssertEquals(event.status, kMMLEventNoteOff, @"");
    STAssertEquals(event.noteNumber, 3, @"");
    STAssertEquals(event.velocity, 4, @"");
}

- (void)testSettingTempo
{
    [event setTempo:5];
    STAssertEquals(event.status, kMMLEventTempo, @"");
    STAssertEquals(event.tempo, 5, @"");
}

- (void)testSettingVolume
{
    [event setVolume:6];
    STAssertEquals(event.status, kMMLEventVolume, @"");
    STAssertEquals(event.volume, 6, @"");
}

- (void)testSettingForm
{
    [event setForm:7 subform:8];
    STAssertEquals(event.status, kMMLEventForm, @"");
    STAssertEquals(event.form, 7, @"");
    STAssertEquals(event.subform, 8, @"");
}

- (void)testSettingEnvelopeVCO
{
    [event setEnvelopeForVCOWithAttack:9
                                 decay:10
                               sustain:11
                               release:12];
    STAssertEquals(event.status, kMMLEventEnvelopeForVCO, @"");
    STAssertEquals(event.envelopeAttack, 9, @"");
    STAssertEquals(event.envelopeDecay, 10, @"");
    STAssertEquals(event.envelopeSustain, 11, @"");
    STAssertEquals(event.envelopeRelease, 12, @"");
}

- (void)testSettingEnvelopeVCF
{
    [event setEnvelopeForVCFWithAttack:13
                                 decay:14
                               sustain:15
                               release:16];
    STAssertEquals(event.status, kMMLEventEnvelopeForVCF, @"");
    STAssertEquals(event.envelopeAttack, 13, @"");
    STAssertEquals(event.envelopeDecay, 14, @"");
    STAssertEquals(event.envelopeSustain, 15, @"");
    STAssertEquals(event.envelopeRelease, 16, @"");
}

- (void)testSettingNoiseFrequency
{
    [event setNoiseFrequency:17];
    STAssertEquals(event.status, kMMLEventNoiseFrequency, @"");
    STAssertEquals(event.noiseFrequency, 17, @"");
}

- (void)testSettingPWM
{
    [event setPWM:18];
    STAssertEquals(event.status, kMMLEventPWM, @"");
    STAssertEquals(event.PWM, 18, @"");
}

- (void)testSettingPan
{
    [event setPan:19];
    STAssertEquals(event.status, kMMLEventPan, @"");
    STAssertEquals(event.pan, 19, @"");
}

- (void)testSettingFormantVowel
{
    [event setFormantVowel:kMMLFormantVowelA];
    STAssertEquals(event.status, kMMLEventFormant, @"");
    STAssertEquals(event.vowel, kMMLFormantVowelA, @"");
}

- (void)testSettingDetune
{
    [event setDetune:20];
    STAssertEquals(event.status, kMMLEventDetune, @"");
    STAssertEquals(event.detune, 20, @"");
}

- (void)testSetingLFO
{
    [event setLFOForm:kMMLOscillatorGBWave
              subform:kMMLOscillatorFCNoise
                depth:21
                width:22
                delay:23
                 time:24
              reverse:YES];
    STAssertEquals(event.status, kMMLEventLFO, @"");
    STAssertEquals(event.LFOForm, kMMLOscillatorGBWave, @"");
    STAssertEquals(event.LFOSubform, kMMLOscillatorFCNoise, @"");
    STAssertEquals(event.LFODepth, 21, @"");
    STAssertEquals(event.LFOWidth, 22, @"");
    STAssertEquals(event.LFODelay, 23, @"");
    STAssertEquals(event.LFOTime, 24, @"");
    STAssertEquals(event.LFOReverse, YES, @"");
}

- (void)testSettingLPF
{
    [event setLPFSwitch:kMMLFilterLPFFast
                 amount:25
              frequency:26
              resonance:27];
    STAssertEquals(event.status, kMMLEventLPF, @"");
    STAssertEquals(event.LPFAmount, 25, @"");
    STAssertEquals(event.LPFFrequency, 26, @"");
    STAssertEquals(event.LPFResonance, 27, @"");
}

- (void)testSettingClose
{
    [event setClose];
    STAssertEquals(event.status, kMMLEventClose, @"");
}

- (void)testSettingVolumeMode
{
    [event setVolumeMode:28];
    STAssertEquals(event.status, kMMLEventVolumeMode, @"");
    STAssertEquals(event.volumeMode, 28, @"");
}

- (void)testSettingInput
{
    [event setInputWithSens:29
                       pipe:30];
    STAssertEquals(event.status, kMMLEventInput, @"");
    STAssertEquals(event.inputSens, 29, @"");
    STAssertEquals(event.inputPipe, 30, @"");
}

- (void)testSettingOutput
{
    [event setOutputWithMode:31
                        pipe:32];
    STAssertEquals(event.status, kMMLEventOutput, @"");
    STAssertEquals(event.outputMode, 31, @"");
    STAssertEquals(event.outputPipe, 32, @"");
}

- (void)testSettingDelta
{
    [event setDelta:32];
    STAssertEquals(event.delta, 32, @"");
}

@end
