package jp.sourceforge.ocmml.android.modulators;

public final class FCTriangle extends Modulator {
    private static int FC_TRIANGLE_TABLE_LENGTH = 1 << 5;

    private static void initialize() {
        if (!sInitialized) {
            int tableIndex = FC_TRIANGLE_TABLE_LENGTH - 1;
            for (int i = 0; i < FC_TRIANGLE_TABLE_LENGTH; i++)
                sTable[i] = sTable[tableIndex - i] = i * 2.0 / 15.0 - 1.0;
            sInitialized = true;
        }
    }

    public FCTriangle() {
        super();
        initialize();
    }

    @Override
	public double getNextSampleOfs(int ofs) {
        double value = sTable[((mPhase + ofs) & PHASE_MASK) >> (PHASE_SHIFT + 11)];
        addPhase(1);
        return value;
    }

    @Override
    public double getNextSample() {
        double value = sTable[mPhase >> (PHASE_SHIFT + 11)];
        addPhase(1);
        return value;
    }

    private static Boolean sInitialized = false;
    private static double[] sTable = new double[FC_TRIANGLE_TABLE_LENGTH];
}
