/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
// $Id: Sample.cs 117 2009-05-23 15:29:19Z hikarin $
//

using System;

namespace SlMML
{
    public static class Sample
    {
        #region 定数の定義
        public const int RATE = 44100;
        public const int FREQUENCY_BASE = 440;
        #endregion

        #region 公開メソッドの定義
        /// <summary>
        /// 倍精度浮動点小数を16bit整数値に変換します
        /// </summary>
        /// <remarks>
        /// 基本的にサンプルバッファがdoubleの配列で処理されるので、
        /// GetSampleAsyncでdoubleから16bitの整数値(16bitPCM)に変換を実行する
        /// </remarks>
        /// <param name="s">倍精度浮動点小数の値</param>
        /// <returns>16bitの整数値</returns>
        public static short ToShort(this double s)
        {
            return (short)Math.Round(s * 16384);
        }
        #endregion
    }
}
