/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
// $Id: Triangle.cs 100 2009-05-09 13:52:19Z hikarin $
//

namespace SlMML.Modulators
{
    sealed class Triangle : Modulator, IModulator
    {
        #region 非公開クラスメソッドの定義
        private static void Initialize()
        {
            if (!s_initialized)
            {
                double d0 = 1.0 / TABLE_LENGTH, p0 = 0;
                for (int i = 0; i < TABLE_LENGTH; i++)
                {
                    s_table[i] = p0 < 0.5 ? 1 - 4 * p0 : 1 - 4 * (1 - p0);
                    p0 += d0;
                }
                s_initialized = true;
            }
        }
        #endregion

        #region コンストラクタおよびデストラクタの定義
        public Triangle() : base()
        {
            Initialize();
        }
        #endregion

        #region 公開メソッドの定義
        public double NextSampleOfs(int ofs)
        {
            double value = s_table[m_phase >> PHASE_SHIFT];
            AddPhase(1);
            return value;
        }

        public void GetSamples(ref double[] samples, int start, int end)
        {
            for (int i = start; i < end; i++)
                samples[i] = NextSample;
        }
        #endregion

        #region 公開プロパティの定義
        public double NextSample
        {
            get
            {
                double val = s_table[m_phase >> PHASE_SHIFT];
                AddPhase(1);
                return val;
            }
        }
        #endregion

        #region メンバー変数の定義
        private static bool s_initialized = false;
        private static double[] s_table = new double[TABLE_LENGTH];
        #endregion
    }
}
