package jp.sourceforge.ocmml.android.modulators;

import java.nio.DoubleBuffer;

public final class GBWave extends Modulator {
    private static final int MAX_WAVE = 16;
    private static final int GBWAVE_TABLE_LENGTH = 1 << 5;

    public static void setWaveString(String wave, int index) {
        char[] chars = wave.toLowerCase().toCharArray();
        int i = 0, pos = 0, length = chars.length;
        index = Math.min(Math.max(index, 0), MAX_WAVE - 1);
        while (i < GBWAVE_TABLE_LENGTH) {
            char c = chars[pos++];
            if (Character.isWhitespace(c))
                continue;
            else if (length <= pos)
                break;
            else if (48 <= c && c < 58)
                c -= 48;
            else if (97 <= c && c < 103)
                c -= (97 - 10);
            else
                c = 0;
            sTable[index][i] = (c - 7.5) / 7.5;
            i++;
        }
    }

    private static void initialize() {
        if (!sInitialized) {
            setWaveString("0123456789abcdeffedcba9876543210", 0);
            sInitialized = true;
        }
    }

    public GBWave() {
        super();
        initialize();
    }

    public double getNextSampleOfs(int ofs) {
        double value = sTable[mIndex][((mPhase + ofs) & PHASE_MASK) >> (PHASE_SHIFT - 11)];
        addPhase(1);
        return value;
    }

    public void getSample(DoubleBuffer samples, int start, int end) {
        for (int i = start; i < end; i++)
            samples.put(i, getNextSample());
    }

    @Override
    public double getNextSample() {
        double value = sTable[mIndex][mPhase >> (PHASE_SHIFT + 11)];
        addPhase(1);
        return value;
    }

    public int getWaveIndex() {
        return mIndex;
    }

    public void setWaveIndex(int value) {
        mIndex = Math.min(Math.max(value, 0), MAX_WAVE - 1);
    }

    private static Boolean sInitialized = false;
    private static double[][] sTable = new double[MAX_WAVE][GBWAVE_TABLE_LENGTH];
    private int mIndex;
}
