package jp.sourceforge.ocmml.android;

import java.nio.DoubleBuffer;

public class Formant {
    public static final int UNKNOWN = -1;
    public static final int A = 0;
    public static final int E = 1;
    public static final int I = 2;
    public static final int O = 3;
    public static final int U = 4;

    public Formant() {
        mVowel = A;
        mPower = false;
        mLeftMemory = new double[10];
        mRightMemory = new double[10];
    }

    public void disable() {
        mPower = false;
        reset();
    }

    public void reset() {
        for (int i = 0; i < 10; i++)
            mLeftMemory[i] = mRightMemory[i] = 0;
    }

    public void getSample(DoubleBuffer samples, int start, int end) {
        if (!mPower || mVowel == UNKNOWN)
            return;
        double[] coeff = mCoeff[mVowel];
        for (int i = start; i < end; i++) {
            double sample = samples.get(i);
            double value = coeff[0] * sample + coeff[1] * mLeftMemory[0]
                    + coeff[2] * mLeftMemory[1] + coeff[3] * mLeftMemory[2]
                    + coeff[4] * mLeftMemory[3] + coeff[5] * mLeftMemory[4]
                    + coeff[6] * mLeftMemory[5] + coeff[7] * mLeftMemory[6]
                    + coeff[8] * mLeftMemory[7] + coeff[9] * mLeftMemory[8]
                    + coeff[10] * mLeftMemory[9];
            samples.put(i, sample);
            mLeftMemory[9] = mLeftMemory[8];
            mLeftMemory[8] = mLeftMemory[7];
            mLeftMemory[7] = mLeftMemory[6];
            mLeftMemory[6] = mLeftMemory[5];
            mLeftMemory[5] = mLeftMemory[4];
            mLeftMemory[4] = mLeftMemory[3];
            mLeftMemory[3] = mLeftMemory[2];
            mLeftMemory[2] = mLeftMemory[1];
            mLeftMemory[1] = mLeftMemory[0];
            mLeftMemory[0] = value;
        }
    }

    public void setVowel(int value) {
        mPower = true;
        mVowel = Math.min(Math.max(value, UNKNOWN), U);
    }

    private double[][] mCoeff = new double[][] {
            new double[] { 8.11044e-06, 8.943665402, -36.83889529, 92.01697887,
                    -154.337906, 181.6233289, -151.8651235, 89.09614114,
                    -35.10298511, 8.388101016, -0.923313471 },
            new double[] { 4.36215e-06, 8.90438318, -36.55179099, 91.05750846,
                    -152.422234, 179.1170248, -149.6496211, 87.78352223,
                    -34.60687431, 8.282228154, -0.914150747 },
            new double[] { 3.33819e-06, 8.893102966, -36.49532826, 90.96543286,
                    -152.4545478, 179.4835618, -150.315433, 88.43409371,
                    -34.98612086, 8.407803364, -0.932568035 },
            new double[] { 1.13572e-06, 8.994734087, -37.2084849, 93.22900521,
                    -156.6929844, 184.596544, -154.3755513, 90.49663749,
                    -35.58964535, 8.478996281, -0.929252233 },
            new double[] { 4.09431e-07, 8.997322763, -37.20218544, 93.11385476,
                    -156.2530937, 183.7080141, -153.2631681, 89.59539726,
                    -35.12454591, 8.338655623, -0.910251753 } };
    private double[] mLeftMemory;
    private double[] mRightMemory;
    private int mVowel;
    private Boolean mPower;
}
