/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyutech.ai.ylab.shiva.nyatools.utils;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import jp.ac.kyutech.ai.ylab.shiva.nyatools.utils.Misc;

public class DeviceDetectionUtil {
    private static String classPath = null;

    public static SecurityManager disableSecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        return sm;
    }

    public static void enableSecurityManamger(SecurityManager sm) {
        System.setSecurityManager(sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyJMFProperties() {
        File f;
        String tmpDir = System.getProperty("user.home");
        File dir = new File(tmpDir);
        if (!dir.exists()) {
            System.out.println("Creating directory at : " + dir.getAbsolutePath());
            dir.mkdirs();
        }
        if (!(f = new File(dir, "jmf.properties")).exists()) {
            System.out.println("copying jmf.properties to : " + f.getAbsolutePath());
            InputStream is = null;
            byte[] ba = null;
            try {
                is = DeviceDetectionUtil.class.getResourceAsStream("jmf.properties");
                ba = Misc.readAll(is);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(f));
                os.write(ba);
            }
            catch (IOException e) {
                System.out.println("WARNING : Couldn't copy jmf.properties to : " + dir.getAbsolutePath());
            }
            finally {
                try {
                    if (os != null) {
                        os.flush();
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("jmf.properties is found at : " + f.getAbsolutePath());
        }
    }

    private static void preProccess() {
        String tmpDir = System.getProperty("user.home");
        File dir = new File(tmpDir);
        classPath = System.getProperty("java.class.path");
        System.setProperty("java.class.path", dir.getAbsolutePath());
    }

    private static void postProccess() {
        System.setProperty("java.class.path", classPath);
    }

    public static boolean doDetection() {
        SecurityManager sm = DeviceDetectionUtil.disableSecurityManager();
        DeviceDetectionUtil.copyJMFProperties();
        if (!DeviceDetectionUtil.isDeviceAvailable(320, 240, 30.0f, "RGB")) {
            JFrame dialog = new JFrame();
            dialog.setResizable(false);
            dialog.setAlwaysOnTop(true);
            dialog.setTitle("Device Detection");
            dialog.setDefaultCloseOperation(3);
            dialog.setLayout(new GridLayout(3, 1));
            dialog.add(new JLabel(" Detecting capturing devices... "));
            JProgressBar b = new JProgressBar();
            b.setIndeterminate(true);
            dialog.add(b);
            dialog.add(new JLabel(" (this will take a couple of minutes) "));
            dialog.pack();
            dialog.setVisible(true);
            DeviceDetectionUtil.detect();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(false);
        }
        if (!DeviceDetectionUtil.isDeviceAvailable(320, 240, 30.0f, "RGB")) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Couldn't find any capturing device.", "No Capturing Device Error", 0);
            return false;
        }
        DeviceDetectionUtil.enableSecurityManamger(sm);
        return true;
    }

    public static void detect() {
        DeviceDetectionUtil.preProccess();
        Class<?> directAudio = null;
        Class<?> autoAudio = null;
        Class<?> autoVideo = null;
        Class<?> autoVideoPlus = null;
        try {
            directAudio = Class.forName("DirectSoundAuto");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            autoAudio = Class.forName("JavaSoundAuto");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            autoVideo = Class.forName("VFWAuto");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (autoVideo == null) {
            try {
                autoVideo = Class.forName("SunVideoAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
            try {
                autoVideoPlus = Class.forName("SunVideoPlusAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        if (autoVideo == null) {
            try {
                autoVideo = Class.forName("V4LAuto");
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
        if (directAudio == null && autoAudio == null && autoVideo == null && autoVideoPlus == null) {
            return;
        }
        try {
            if (directAudio != null) {
                directAudio.newInstance();
            }
            if (autoAudio != null) {
                autoAudio.newInstance();
            }
            if (autoVideo != null) {
                autoVideo.newInstance();
            }
            if (autoVideoPlus != null) {
                autoVideoPlus.newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        DeviceDetectionUtil.postProccess();
    }

    public static boolean isDeviceAvailable(int width, int height, float rate, String pixcelFormat) {
        DeviceDetectionUtil.preProccess();
        String encoding = pixcelFormat;
        Dimension size = new Dimension(width, height);
        VideoFormat format = new VideoFormat(encoding, size, -1, null, rate);
        Vector devices = CaptureDeviceManager.getDeviceList((Format)format);
        if (devices.size() < 1) {
            System.err.println("! No Devices for " + format);
            DeviceDetectionUtil.postProccess();
            return false;
        }
        DeviceDetectionUtil.postProccess();
        return true;
    }
}

