/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilter;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARSensor {
    protected NyARHistogram _gs_hist;
    protected INyARRgbRaster _ref_raster = null;
    protected INyARGrayscaleRaster _gs_raster;
    protected long _src_ts;
    protected long _gs_id_ts;
    protected long _gs_hist_ts;
    private INyARHistogramFromRaster _hist_drv = null;
    private INyARPerspectiveCopy _pcopy;
    private INyARRgb2GsFilter _rgb2gs = null;

    public NyARSensor(NyARIntSize i_size) throws NyARException {
        this.initInstance(i_size);
        this._hist_drv = (INyARHistogramFromRaster)this._gs_raster.createInterface(INyARHistogramFromRaster.class);
    }

    protected void initResource(NyARIntSize s) throws NyARException {
        this._gs_raster = new NyARGrayscaleRaster(s.w, s.h, 262145, true);
    }

    private void initInstance(NyARIntSize i_size) throws NyARException {
        this.initResource(i_size);
        this._gs_hist = new NyARHistogram(256);
        this._src_ts = 0L;
        this._gs_id_ts = 0L;
        this._gs_hist_ts = 0L;
    }

    public INyARPerspectiveCopy getPerspectiveCopy() {
        return this._pcopy;
    }

    public void update(INyARRgbRaster i_input) throws NyARException {
        if (this._ref_raster != i_input) {
            this._rgb2gs = (INyARRgb2GsFilter)i_input.createInterface(INyARRgb2GsFilter.class);
            this._pcopy = (INyARPerspectiveCopy)i_input.createInterface(INyARPerspectiveCopy.class);
            this._ref_raster = i_input;
        }
        ++this._src_ts;
    }

    public void updateTimeStamp() {
        ++this._src_ts;
    }

    public long getTimeStamp() {
        return this._src_ts;
    }

    public INyARGrayscaleRaster getGsImage() throws NyARException {
        if (this._src_ts != this._gs_id_ts) {
            this._rgb2gs.convert(this._gs_raster);
            this._gs_id_ts = this._src_ts;
        }
        return this._gs_raster;
    }

    public NyARHistogram getGsHistogram() throws NyARException {
        if (this._gs_id_ts != this._gs_hist_ts) {
            this._hist_drv.createHistogram(4, this._gs_hist);
            this._gs_hist_ts = this._gs_id_ts;
        }
        return this._gs_hist;
    }

    public INyARRgbRaster getSourceImage() {
        return this._ref_raster;
    }

    public INyARRgbRaster getPerspectiveImage(int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, INyARRgbRaster i_raster) throws NyARException {
        this._pcopy.copyPatt(i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, 0, 0, 1, i_raster);
        return i_raster;
    }

    public INyARRgbRaster getPerspectiveImage(double i_x1, double i_y1, double i_x2, double i_y2, double i_x3, double i_y3, double i_x4, double i_y4, INyARRgbRaster i_raster) throws NyARException {
        this._pcopy.copyPatt(i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, 0, 0, 1, i_raster);
        return i_raster;
    }
}

