/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterdriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARHistogramFromRaster_AnyGs
implements INyARHistogramFromRaster {
    private INyARGrayscaleRaster _gsr;

    public NyARHistogramFromRaster_AnyGs(INyARGrayscaleRaster i_raster) {
        this._gsr = i_raster;
    }

    @Override
    public void createHistogram(int i_skip, NyARHistogram o_histogram) throws NyARException {
        NyARIntSize s = this._gsr.getSize();
        this.createHistogram(0, 0, s.w, s.h, i_skip, o_histogram);
    }

    @Override
    public void createHistogram(int i_l, int i_t, int i_w, int i_h, int i_skip, NyARHistogram o_histogram) throws NyARException {
        o_histogram.reset();
        int[] data_ptr = o_histogram.data;
        INyARGsPixelDriver drv = this._gsr.getGsPixelDriver();
        int pix_count = i_w;
        int pix_mod_part = pix_count - pix_count % 8;
        int y = i_h - 1;
        while (y >= 0) {
            int x = pix_count - 1;
            while (x >= pix_mod_part) {
                int n = drv.getPixel(x, y);
                data_ptr[n] = data_ptr[n] + 1;
                --x;
            }
            y -= i_skip;
        }
        o_histogram.total_of_data = i_w * i_h / i_skip;
    }
}

