/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARMatchPattDeviationDataDriver_RGBAny
implements NyARMatchPattDeviationColorData.IRasterDriver {
    private INyARRgbRaster _ref_raster;
    private int[] __rgb = new int[3];

    public NyARMatchPattDeviationDataDriver_RGBAny(INyARRgbRaster i_raster) {
        this._ref_raster = i_raster;
    }

    @Override
    public double makeColorData(int[] o_out) throws NyARException {
        NyARIntSize size = this._ref_raster.getSize();
        INyARRgbPixelDriver pixdev = this._ref_raster.getRgbPixelDriver();
        int[] rgb = this.__rgb;
        int width = size.w;
        int ave = 0;
        int y = size.h - 1;
        while (y >= 0) {
            int x = width - 1;
            while (x >= 0) {
                pixdev.getPixel(x, y, rgb);
                ave += rgb[0] + rgb[1] + rgb[2];
                --x;
            }
            --y;
        }
        int number_of_pix = size.w * size.h;
        ave = number_of_pix * 255 * 3 - ave;
        ave = 255 - ave / (number_of_pix * 3);
        int sum = 0;
        int input_ptr = number_of_pix * 3 - 1;
        int y2 = size.h - 1;
        while (y2 >= 0) {
            int x = width - 1;
            while (x >= 0) {
                pixdev.getPixel(x, y2, rgb);
                int w_sum = ave - rgb[2];
                o_out[input_ptr--] = w_sum;
                sum += w_sum * w_sum;
                w_sum = ave - rgb[1];
                o_out[input_ptr--] = w_sum;
                sum += w_sum * w_sum;
                w_sum = ave - rgb[0];
                o_out[input_ptr--] = w_sum;
                sum += w_sum * w_sum;
                --x;
            }
            --y2;
        }
        double p = Math.sqrt(sum);
        return p != 0.0 ? p : 1.0E-7;
    }
}

