/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pixeldriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

final class NyARRgbPixelDriver_WORD1D_R5G6B5_16LE
implements INyARRgbPixelDriver {
    private short[] _ref_buf;
    private NyARIntSize _ref_size;

    NyARRgbPixelDriver_WORD1D_R5G6B5_16LE() {
    }

    @Override
    public NyARIntSize getSize() {
        return this._ref_size;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        short[] buf = this._ref_buf;
        int y = i_y;
        int idx = y * this._ref_size.w + i_x;
        int pixcel = buf[idx] & 0xFFFF;
        o_rgb[0] = (pixcel & 0xF800) >> 8;
        o_rgb[1] = (pixcel & 0x7E0) >> 3;
        o_rgb[2] = (pixcel & 0x1F) << 3;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int stride = this._ref_size.w;
        short[] buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int idx = i_y[i] * stride + i_x[i];
            int pixcel = buf[idx] & 0xFFFF;
            o_rgb[i * 3 + 0] = (pixcel & 0xF800) >> 8;
            o_rgb[i * 3 + 1] = (pixcel & 0x7E0) >> 3;
            o_rgb[i * 3 + 2] = (pixcel & 0x1F) << 3;
            --i;
        }
    }

    @Override
    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_r, int i_g, int i_b) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void switchRaster(INyARRgbRaster i_raster) throws NyARException {
        this._ref_buf = (short[])i_raster.getBuffer();
        this._ref_size = i_raster.getSize();
    }
}

