/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.psarplaycard;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARGsPixelDriver;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator_O1;
import jp.nyatla.nyartoolkit.psarplaycard.MarkerPattDecoder;

final class PerspectivePixelReader {
    private static int READ_RESOLUTION = 100;
    private NyARPerspectiveParamGenerator _param_gen = new NyARPerspectiveParamGenerator_O1(1, 1);
    private double[] _cparam = new double[8];
    private static final int MAX_FREQ = 10;
    private static final int MAX_DATA_BITS = 19;
    private final int[] _ref_x = new int[108];
    private final int[] _ref_y = new int[108];
    private int[] _pixcel_temp = new int[108];
    private double[] __readDataBits_index_bit_x = new double[38];
    private double[] __readDataBits_index_bit_y = new double[38];

    public boolean setSourceSquare(NyARIntPoint2d[] i_vertex) throws NyARException {
        return this._param_gen.getParam(READ_RESOLUTION, READ_RESOLUTION, i_vertex, this._cparam);
    }

    public boolean setSourceSquare(NyARDoublePoint2d[] i_vertex) throws NyARException {
        return this._param_gen.getParam(READ_RESOLUTION, READ_RESOLUTION, i_vertex, this._cparam);
    }

    private void detectDataBitsIndex(double[] o_index_row, double[] o_index_col) throws NyARException {
        int i = 0;
        while (i < 3) {
            o_index_row[i * 2] = 25 + i * 20;
            o_index_row[i * 2 + 1] = 35 + i * 20;
            o_index_col[i * 2] = 25 + i * 20;
            o_index_col[i * 2 + 1] = 35 + i * 20;
            ++i;
        }
    }

    public boolean readDataBits(INyARGsPixelDriver i_reader, NyARIntSize i_raster_size, MarkerPattDecoder o_bitbuffer) throws NyARException {
        int raster_width = i_raster_size.w;
        int raster_height = i_raster_size.h;
        double[] index_x = this.__readDataBits_index_bit_x;
        double[] index_y = this.__readDataBits_index_bit_y;
        this.detectDataBitsIndex(index_x, index_y);
        int resolution = 3;
        double[] cpara = this._cparam;
        int[] ref_x = this._ref_x;
        int[] ref_y = this._ref_y;
        int[] pixcel_temp = this._pixcel_temp;
        double cpara_0 = cpara[0];
        double cpara_1 = cpara[1];
        double cpara_3 = cpara[3];
        double cpara_6 = cpara[6];
        int p = 0;
        int i = 0;
        while (i < 3) {
            double cy0 = 1.0 + index_y[i * 2 + 0];
            double cy1 = 1.0 + index_y[i * 2 + 1];
            double cpy0_12 = cpara_1 * cy0 + cpara[2];
            double cpy0_45 = cpara[4] * cy0 + cpara[5];
            double cpy0_7 = cpara[7] * cy0 + 1.0;
            double cpy1_12 = cpara_1 * cy1 + cpara[2];
            double cpy1_45 = cpara[4] * cy1 + cpara[5];
            double cpy1_7 = cpara[7] * cy1 + 1.0;
            int pt = 0;
            int i2 = 0;
            while (i2 < 3) {
                int yy;
                int xx;
                double cx0 = 1.0 + index_x[i2 * 2 + 0];
                double cx1 = 1.0 + index_x[i2 * 2 + 1];
                double cp6_0 = cpara_6 * cx0;
                double cpx0_0 = cpara_0 * cx0;
                double cpx3_0 = cpara_3 * cx0;
                double cp6_1 = cpara_6 * cx1;
                double cpx0_1 = cpara_0 * cx1;
                double cpx3_1 = cpara_3 * cx1;
                double d = cp6_0 + cpy0_7;
                ref_x[pt] = xx = (int)((cpx0_0 + cpy0_12) / d);
                ref_y[pt] = yy = (int)((cpx3_0 + cpy0_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : xx);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : yy);
                }
                d = cp6_0 + cpy1_7;
                ref_x[++pt] = xx = (int)((cpx0_0 + cpy1_12) / d);
                ref_y[pt] = yy = (int)((cpx3_0 + cpy1_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : xx);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : yy);
                }
                d = cp6_1 + cpy0_7;
                ref_x[++pt] = xx = (int)((cpx0_1 + cpy0_12) / d);
                ref_y[pt] = yy = (int)((cpx3_1 + cpy0_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : xx);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : yy);
                }
                d = cp6_1 + cpy1_7;
                ref_x[++pt] = xx = (int)((cpx0_1 + cpy1_12) / d);
                ref_y[pt] = yy = (int)((cpx3_1 + cpy1_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : xx);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : yy);
                }
                ++pt;
                ++i2;
            }
            i_reader.getPixelSet(ref_x, ref_y, 12, pixcel_temp, 0);
            i2 = 0;
            while (i2 < 3) {
                int index = i2 * 4;
                o_bitbuffer.setBit(p, (pixcel_temp[index + 0] + pixcel_temp[index + 1] + pixcel_temp[index + 2] + pixcel_temp[index + 3]) / 4);
                ++p;
                ++i2;
            }
            ++i;
        }
        return true;
    }
}

