/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import java.io.InputStream;
import java.io.OutputStream;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.INyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactorV2;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactorV4;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix33;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.core.utils.ByteBufferedInputStream;

public class NyARParam {
    protected NyARIntSize _screen_size = new NyARIntSize();
    private INyARCameraDistortionFactor _dist;
    private NyARPerspectiveProjectionMatrix _projection_matrix = new NyARPerspectiveProjectionMatrix();

    public static NyARParam createDefaultParameter() throws NyARException {
        ParamLoader pm = new ParamLoader();
        return new NyARParam(pm.size, pm.pmat, pm.dist_factor);
    }

    public static NyARParam createFromARParamFile(InputStream i_stream) throws NyARException {
        ParamLoader pm = new ParamLoader(i_stream);
        return new NyARParam(pm.size, pm.pmat, pm.dist_factor);
    }

    public static NyARParam createFromCvCalibrateCamera2Result(int i_w, int i_h, double[] i_intrinsic_matrix, double[] i_distortion_coeffs) {
        ParamLoader pm = new ParamLoader(i_w, i_h, i_intrinsic_matrix, i_distortion_coeffs);
        return new NyARParam(pm.size, pm.pmat, pm.dist_factor);
    }

    public NyARParam(NyARIntSize i_screen_size, NyARPerspectiveProjectionMatrix i_projection_mat, INyARCameraDistortionFactor i_dist_factor) {
        this._screen_size = new NyARIntSize(i_screen_size);
        this._dist = i_dist_factor;
        this._projection_matrix = i_projection_mat;
    }

    public NyARIntSize getScreenSize() {
        return this._screen_size;
    }

    public NyARPerspectiveProjectionMatrix getPerspectiveProjectionMatrix() {
        return this._projection_matrix;
    }

    public INyARCameraDistortionFactor getDistortionFactor() {
        return this._dist;
    }

    public void setValue(double[] i_factor, double[] i_projection) {
        this._dist.setValue(i_factor);
        this._projection_matrix.setValue(i_projection);
    }

    public void changeScreenSize(int i_xsize, int i_ysize) {
        double x_scale = (double)i_xsize / (double)this._screen_size.w;
        double y_scale = (double)i_ysize / (double)this._screen_size.h;
        this._dist.changeScale(x_scale, y_scale);
        this._projection_matrix.changeScale(x_scale, y_scale);
        this._screen_size.w = i_xsize;
        this._screen_size.h = i_ysize;
    }

    public void changeScreenSize(NyARIntSize i_s) {
        this.changeScreenSize(i_s.w, i_s.h);
    }

    public void makeCameraFrustumRH(double i_dist_min, double i_dist_max, NyARDoubleMatrix44 o_frustum) {
        this._projection_matrix.makeCameraFrustumRH(this._screen_size.w, this._screen_size.h, i_dist_min, i_dist_max, o_frustum);
    }

    public void saveARParam(OutputStream i_stream) throws Exception {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u95a2\u6570");
    }

    protected static class ParamLoader {
        public NyARIntSize size;
        public NyARPerspectiveProjectionMatrix pmat;
        public INyARCameraDistortionFactor dist_factor;

        public ParamLoader(int i_w, int i_h, double[] i_intrinsic_matrix, double[] i_distortion_coeffs) {
            this.size = new NyARIntSize(i_w, i_h);
            NyARCameraDistortionFactorV4 v4dist = new NyARCameraDistortionFactorV4();
            v4dist.setValue(this.size, i_intrinsic_matrix, i_distortion_coeffs);
            double s = v4dist.getS();
            this.dist_factor = v4dist;
            this.pmat = new NyARPerspectiveProjectionMatrix();
            NyARDoubleMatrix33 r = new NyARDoubleMatrix33();
            r.setValue(i_intrinsic_matrix);
            r.m00 /= s;
            r.m01 /= s;
            r.m10 /= s;
            r.m11 /= s;
            this.pmat.setValue(r, new NyARDoublePoint3d());
        }

        public ParamLoader() throws NyARException {
            double[] df = new double[]{318.5, 263.5, 26.2, 1.0127565206658486};
            double[] pj = new double[]{700.9514702992245, 0.0, 316.5, 0.0, 0.0, 726.0941816535367, 241.5, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            this.size = new NyARIntSize(640, 480);
            this.pmat = new NyARPerspectiveProjectionMatrix();
            this.pmat.setValue(pj);
            this.dist_factor = new NyARCameraDistortionFactorV2();
            this.dist_factor.setValue(df);
        }

        public ParamLoader(InputStream i_stream) throws NyARException {
            try {
                double[] df;
                ByteBufferedInputStream bis = new ByteBufferedInputStream(i_stream, 512);
                int s = bis.readToBuffer(512);
                bis.order(2);
                int[] version_table = new int[]{136, 144, 152, 176};
                int version = -1;
                int i = 0;
                while (i < version_table.length) {
                    if (s % version_table[i] == 0) {
                        version = i + 1;
                        break;
                    }
                    ++i;
                }
                if (version == -1) {
                    throw new NyARException();
                }
                this.size = new NyARIntSize();
                this.size.setValue(bis.getInt(), bis.getInt());
                this.pmat = new NyARPerspectiveProjectionMatrix();
                double[] pjv = new double[16];
                int i2 = 0;
                while (i2 < 12) {
                    pjv[i2] = bis.getDouble();
                    ++i2;
                }
                pjv[14] = 0.0;
                pjv[13] = 0.0;
                pjv[12] = 0.0;
                pjv[15] = 1.0;
                this.pmat.setValue(pjv);
                switch (version) {
                    case 1: {
                        df = new double[4];
                        this.dist_factor = new NyARCameraDistortionFactorV2();
                        break;
                    }
                    case 4: {
                        df = new double[9];
                        this.dist_factor = new NyARCameraDistortionFactorV4();
                        break;
                    }
                    default: {
                        throw new NyARException();
                    }
                }
                int i3 = 0;
                while (i3 < df.length) {
                    df[i3] = bis.getDouble();
                    ++i3;
                }
                this.dist_factor.setValue(df);
            }
            catch (Exception e) {
                throw new NyARException(e);
            }
        }
    }
}

