/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.INyARMatchPatt;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationBlackWhiteData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;

public class NyARMatchPatt_BlackWhite
implements INyARMatchPatt {
    protected NyARCode _ref_code_patt;
    protected int _pixels;

    public NyARMatchPatt_BlackWhite(int i_width, int i_height) {
        this._pixels = i_height * i_width;
    }

    public NyARMatchPatt_BlackWhite(NyARCode i_code_ref) {
        this._pixels = i_code_ref.getWidth() * i_code_ref.getHeight();
        this._ref_code_patt = i_code_ref;
    }

    @Override
    public void setARCode(NyARCode i_code_ref) {
        this._ref_code_patt = i_code_ref;
    }

    public boolean evaluate(NyARMatchPattDeviationBlackWhiteData i_patt, NyARMatchPattResult o_result) throws NyARException {
        assert (this._ref_code_patt != null);
        int[] linput = i_patt.getData();
        double max = 0.0;
        int res = -1;
        int j = 0;
        while (j < 4) {
            int sum = 0;
            NyARMatchPattDeviationBlackWhiteData code_patt = this._ref_code_patt.getBlackWhiteData(j);
            int[] pat_j = code_patt.getData();
            int i = this._pixels - 1;
            while (i >= 0) {
                sum += linput[i] * pat_j[i];
                --i;
            }
            double sum2 = (double)sum / code_patt.getPow() / i_patt.getPow();
            if (sum2 > max) {
                max = sum2;
                res = j;
            }
            ++j;
        }
        o_result.direction = res;
        o_result.confidence = max;
        return true;
    }
}

