/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.pickup.IpickFromRaster_Impl;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class pickFromRaster_2x
implements IpickFromRaster_Impl {
    protected NyARIntSize _size_ref;
    protected NyARIntPoint2d _lt_ref;
    private int[] _rgb_temp;
    private int[] _rgb_px;
    private int[] _rgb_py;

    public pickFromRaster_2x(NyARIntPoint2d i_lt, NyARIntSize i_source_size) {
        this._lt_ref = i_lt;
        this._size_ref = i_source_size;
        this._rgb_temp = new int[i_source_size.w * 4 * 3];
        this._rgb_px = new int[i_source_size.w * 4];
        this._rgb_py = new int[i_source_size.w * 4];
    }

    public void pickFromRaster(double[] i_cpara, INyARRgbRaster image, int[] o_patt) throws NyARException {
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        int patt_w = this._size_ref.w;
        int[] rgb_tmp = this._rgb_temp;
        int[] rgb_px = this._rgb_px;
        int[] rgb_py = this._rgb_py;
        double cp0 = i_cpara[0];
        double cp3 = i_cpara[3];
        double cp6 = i_cpara[6];
        double cp1 = i_cpara[1];
        double cp4 = i_cpara[4];
        double cp7 = i_cpara[7];
        int pick_y = this._lt_ref.y;
        int pick_x = this._lt_ref.x;
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        int p = 0;
        double cp1cy_cp20 = cp1 * (double)pick_y + i_cpara[2] + cp0 * (double)pick_x;
        double cp4cy_cp50 = cp4 * (double)pick_y + i_cpara[5] + cp3 * (double)pick_x;
        double cp7cy_10 = cp7 * (double)pick_y + 1.0 + cp6 * (double)pick_x;
        double cp1cy_cp21 = cp1cy_cp20 + cp1;
        double cp4cy_cp51 = cp4cy_cp50 + cp4;
        double cp7cy_11 = cp7cy_10 + cp7;
        double cw0 = cp1 + cp1;
        double cw7 = cp7 + cp7;
        double cw4 = cp4 + cp4;
        int iy = this._size_ref.h - 1;
        while (iy >= 0) {
            double cp0cx0 = cp1cy_cp20;
            double cp3cx0 = cp4cy_cp50;
            double cp0cx1 = cp1cy_cp21;
            double cp3cx1 = cp4cy_cp51;
            double m0 = 1.0 / cp7cy_10;
            double d0 = -cp6 / (cp7cy_10 * (cp7cy_10 + cp6));
            double m1 = 1.0 / cp7cy_11;
            double d1 = -cp6 / (cp7cy_11 * (cp7cy_11 + cp6));
            int n = patt_w * 2 * 2 - 1;
            int ix = patt_w * 2 - 1;
            while (ix >= 0) {
                int x = rgb_px[n] = (int)(cp0cx0 * m0);
                int y = rgb_py[n] = (int)(cp3cx0 * m0);
                if (x < 0 || x >= img_x || y < 0 || y >= img_y) {
                    if (x < 0) {
                        rgb_px[n] = 0;
                    } else if (x >= img_x) {
                        rgb_px[n] = img_x - 1;
                    }
                    if (y < 0) {
                        rgb_py[n] = 0;
                    } else if (y >= img_y) {
                        rgb_py[n] = img_y - 1;
                    }
                }
                cp0cx0 += cp0;
                cp3cx0 += cp3;
                m0 += d0;
                x = rgb_px[--n] = (int)(cp0cx1 * m1);
                y = rgb_py[n] = (int)(cp3cx1 * m1);
                if (x < 0 || x >= img_x || y < 0 || y >= img_y) {
                    if (x < 0) {
                        rgb_px[n] = 0;
                    } else if (x >= img_x) {
                        rgb_px[n] = img_x - 1;
                    }
                    if (y < 0) {
                        rgb_py[n] = 0;
                    } else if (y >= img_y) {
                        rgb_py[n] = img_y - 1;
                    }
                }
                cp0cx1 += cp0;
                cp3cx1 += cp3;
                m1 += d1;
                --n;
                --ix;
            }
            cp7cy_10 += cw7;
            cp7cy_11 += cw7;
            cp1cy_cp20 += cw0;
            cp4cy_cp50 += cw4;
            cp1cy_cp21 += cw0;
            cp4cy_cp51 += cw4;
            reader.getPixelSet(rgb_px, rgb_py, patt_w * 4, rgb_tmp);
            ix = patt_w - 1;
            while (ix >= 0) {
                int idx = ix * 12;
                int r = (rgb_tmp[idx + 0] + rgb_tmp[idx + 3] + rgb_tmp[idx + 6] + rgb_tmp[idx + 9]) / 4;
                int g = (rgb_tmp[idx + 1] + rgb_tmp[idx + 4] + rgb_tmp[idx + 7] + rgb_tmp[idx + 10]) / 4;
                int b = (rgb_tmp[idx + 2] + rgb_tmp[idx + 5] + rgb_tmp[idx + 8] + rgb_tmp[idx + 11]) / 4;
                o_patt[p] = r << 16 | g << 8 | b & 0xFF;
                ++p;
                --ix;
            }
            --iy;
        }
    }
}

