/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker;
import processing.core.PApplet;
import processing.core.PImage;

public class NyARBoard
extends SingleMarkerBaseClass {
    public int lostDelay = 10;
    public int lostCount = 0;
    public double cfThreshold = 0.4;
    public double confidence = 0.0;
    public int gsThreshold = 110;
    private NyARSingleDetectMarker _nya;
    private final NyARTransMatResult _rettmp = new NyARTransMatResult();

    public NyARBoard(PApplet parent, int i_width, int i_height, String i_cparam, String i_patt, int i_patt_width, NyAR4PsgConfig i_config) {
        try {
            this.initInstance(parent, i_cparam, i_patt, i_width, i_height, i_patt_width, i_config);
        }
        catch (Exception e) {
            this._ref_papplet.die("Error at NyARBoard", e);
        }
    }

    public NyARBoard(PApplet parent, int i_width, int i_height, String i_cparam, String i_patt, int i_patt_width) {
        try {
            this.initInstance(parent, i_cparam, i_patt, i_width, i_height, i_patt_width, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception e) {
            this._ref_papplet.die("Error at NyARBoard", e);
        }
    }

    private void initInstance(PApplet parent, String i_cparam, String i_patt, int i_width, int i_height, int i_marker_width, NyAR4PsgConfig i_config) throws NyARException {
        super.initInstance(parent, i_cparam, i_width, i_height, i_config);
        NyARCode code = new NyARCode(16, 16);
        code.loadARPatt(this._ref_papplet.createInput(i_patt));
        int tm_type = i_config.env_transmat_mode == 0 ? 1 : 2;
        this._nya = new NyARSingleDetectMarker(this._ar_param, code, (double)i_marker_width, this._src_raster.getBufferType(), tm_type);
        this._nya.setContinueMode(true);
    }

    public boolean detect(PImage i_image) {
        boolean is_marker_exist = false;
        try {
            double cf;
            this._src_raster.wrapBuffer(i_image);
            is_marker_exist = this._nya.detectMarkerLite((INyARRgbRaster)this._src_raster, this.gsThreshold);
            if (is_marker_exist && (cf = this._nya.getConfidence()) < this.cfThreshold) {
                is_marker_exist = false;
            }
            if (is_marker_exist) {
                this.confidence = this._nya.getConfidence();
                this.lostCount = 0;
                this._nya.getTransmationMatrix(this._rettmp);
                this.updateTransmat(this._nya.refSquare(), this._rettmp);
            } else if (this.lostCount < this.lostDelay) {
                ++this.lostCount;
                is_marker_exist = true;
            } else {
                is_marker_exist = false;
            }
            return is_marker_exist;
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)e));
            return is_marker_exist;
        }
    }
}

