/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.fitveccalc;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransOffset;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;

public class NyARFitVecCalculator {
    private final NyARMat _mat_b = new NyARMat(3, 8);
    private final NyARMat _mat_a = new NyARMat(8, 3);
    private final NyARMat _mat_d = new NyARMat(3, 3);
    private final NyARPerspectiveProjectionMatrix _projection_mat;
    private final NyARCameraDistortionFactor _distortionfactor;
    private final NyARDoublePoint2d[] _fitsquare_vertex = NyARDoublePoint2d.createArray(4);
    private NyARTransOffset _offset_square;
    private final NyARMat _mat_e = new NyARMat(3, 1);
    private final NyARMat _mat_f = new NyARMat(3, 1);
    private final NyARMat __calculateTransferVec_mat_c = new NyARMat(8, 1);
    private final NyARDoublePoint3d[] __calculateTransfer_point3d = NyARDoublePoint3d.createArray(4);

    public NyARFitVecCalculator(NyARPerspectiveProjectionMatrix i_projection_mat_ref, NyARCameraDistortionFactor i_distortion_ref) {
        double[][] a_array = this._mat_a.getArray();
        double[][] b_array = this._mat_b.getArray();
        int i = 0;
        while (i < 4) {
            int x2 = i * 2;
            double d = i_projection_mat_ref.m00;
            b_array[0][x2] = d;
            a_array[x2][0] = d;
            double d2 = i_projection_mat_ref.m01;
            b_array[1][x2] = d2;
            a_array[x2][1] = d2;
            b_array[0][x2 + 1] = 0.0;
            a_array[x2 + 1][0] = 0.0;
            double d3 = i_projection_mat_ref.m11;
            b_array[1][x2 + 1] = d3;
            a_array[x2 + 1][1] = d3;
            ++i;
        }
        this._projection_mat = i_projection_mat_ref;
        this._distortionfactor = i_distortion_ref;
    }

    public void setOffsetSquare(NyARTransOffset i_offset) {
        this._offset_square = i_offset;
    }

    public NyARDoublePoint2d[] getFitSquare() {
        return this._fitsquare_vertex;
    }

    public NyARTransOffset getOffsetVertex() {
        return this._offset_square;
    }

    public void setFittedSquare(NyARDoublePoint2d[] i_square_vertex) throws NyARException {
        NyARDoublePoint2d[] vertex = this._fitsquare_vertex;
        this._distortionfactor.ideal2ObservBatch(i_square_vertex, vertex, 4);
        double cpara02 = this._projection_mat.m02;
        double cpara12 = this._projection_mat.m12;
        NyARMat mat_d = this._mat_d;
        NyARMat mat_a = this._mat_a;
        NyARMat mat_b = this._mat_b;
        double[][] a_array = mat_a.getArray();
        double[][] b_array = mat_b.getArray();
        int i = 0;
        while (i < 4) {
            int x2 = i * 2;
            double d = cpara02 - vertex[i].x;
            b_array[2][x2] = d;
            a_array[x2][2] = d;
            double d2 = cpara12 - vertex[i].y;
            b_array[2][x2 + 1] = d2;
            a_array[x2 + 1][2] = d2;
            ++i;
        }
        mat_d.matrixMul(mat_b, mat_a);
        mat_d.matrixSelfInv();
    }

    public final void calculateTransfer(NyARRotMatrix i_rotation, NyARDoublePoint3d o_transfer) throws NyARException {
        assert (this._offset_square != null);
        double cpara00 = this._projection_mat.m00;
        double cpara01 = this._projection_mat.m01;
        double cpara02 = this._projection_mat.m02;
        double cpara11 = this._projection_mat.m11;
        double cpara12 = this._projection_mat.m12;
        NyARDoublePoint3d[] point3d = this.__calculateTransfer_point3d;
        NyARDoublePoint3d[] vertex3d = this._offset_square.vertex;
        NyARDoublePoint2d[] vertex2d = this._fitsquare_vertex;
        NyARMat mat_c = this.__calculateTransferVec_mat_c;
        double[][] f_array = this._mat_f.getArray();
        double[][] c_array = mat_c.getArray();
        i_rotation.getPoint3dBatch(vertex3d, point3d, 4);
        int i = 0;
        while (i < 4) {
            int x2 = i + i;
            NyARDoublePoint3d point3d_ptr = point3d[i];
            c_array[x2][0] = point3d_ptr.z * vertex2d[i].x - cpara00 * point3d_ptr.x - cpara01 * point3d_ptr.y - cpara02 * point3d_ptr.z;
            c_array[x2 + 1][0] = point3d_ptr.z * vertex2d[i].y - cpara11 * point3d_ptr.y - cpara12 * point3d_ptr.z;
            ++i;
        }
        this._mat_e.matrixMul(this._mat_b, mat_c);
        this._mat_f.matrixMul(this._mat_d, this._mat_e);
        o_transfer.x = f_array[0][0];
        o_transfer.y = f_array[1][0];
        o_transfer.z = f_array[2][0];
    }
}

