/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.labeling;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.INyARLabelingImage;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingLabel;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingLabelStack;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARLabelingImage
extends NyARRaster_BasicClass
implements INyARLabelingImage {
    private static final int MAX_LABELS = 32768;
    protected int[] _ref_buf;
    private INyARBufferReader _buffer_reader;
    protected NyARLabelingLabelStack _label_list;
    protected int[] _index_table;
    protected boolean _is_index_table_enable;
    protected final int[] _getContour_xdir;
    protected final int[] _getContour_ydir;

    public NyARLabelingImage(int i_width, int i_height) {
        super(new NyARIntSize(i_width, i_height));
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        this._getContour_xdir = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[7] = -1;
        this._getContour_ydir = nArray2;
        this._ref_buf = new int[i_height * i_width];
        this._label_list = new NyARLabelingLabelStack(32768);
        this._index_table = new int[32768];
        this._is_index_table_enable = false;
        this._buffer_reader = new NyARBufferReader(this._ref_buf, 262144);
    }

    public INyARBufferReader getBufferReader() {
        return this._buffer_reader;
    }

    public int[] getIndexArray() {
        return this._is_index_table_enable ? this._index_table : null;
    }

    public NyARLabelingLabelStack getLabelStack() {
        return this._label_list;
    }

    public void reset(boolean i_label_index_enable) {
        assert (i_label_index_enable);
        this._label_list.clear();
        this._is_index_table_enable = i_label_index_enable;
    }

    protected int getTopClipTangentX(NyARLabelingLabel i_label) throws NyARException {
        int i_label_id = i_label.id;
        int[] index_table = this._index_table;
        int[] limage = this._ref_buf;
        int limage_ptr = i_label.clip_t * this._size.w;
        int clip1 = i_label.clip_r;
        int i = i_label.clip_l;
        while (i <= clip1) {
            int pix = limage[limage_ptr + i];
            if (pix > 0 && index_table[pix - 1] == i_label_id) {
                return i;
            }
            ++i;
        }
        throw new NyARException();
    }

    public int getContour(int i_index, int i_array_size, int[] o_coord_x, int[] o_coord_y) throws NyARException {
        int coord_num;
        block3: {
            int width = this._size.w;
            int[] xdir = this._getContour_xdir;
            int[] ydir = this._getContour_ydir;
            NyARLabelingLabel label = (NyARLabelingLabel)this._label_list.getItem(i_index);
            int sx = this.getTopClipTangentX(label);
            int sy = label.clip_t;
            coord_num = 1;
            o_coord_x[0] = sx;
            o_coord_y[0] = sy;
            int dir = 5;
            int[] limage = this._ref_buf;
            int c = o_coord_x[0];
            int r = o_coord_y[0];
            do {
                dir = (dir + 5) % 8;
                int i = 0;
                while (i < 8) {
                    if (limage[(r + ydir[dir]) * width + (c + xdir[dir])] > 0) break;
                    dir = (dir + 1) % 8;
                    ++i;
                }
                if (i == 8) {
                    throw new NyARException();
                }
                o_coord_x[coord_num] = c += xdir[dir];
                o_coord_y[coord_num] = r += ydir[dir];
                if (c == sx && r == sy) break block3;
            } while (++coord_num != i_array_size);
            return coord_num;
        }
        return ++coord_num;
    }
}

