/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;

public class NyARMatchPatt_Color_WITH_PCA
extends NyARMatchPatt_Color_WITHOUT_PCA {
    private final int EVEC_MAX = 10;
    private int evec_dim;
    private double[][] evec;
    private double[][] epat = new double[4][10];

    public NyARMatchPatt_Color_WITH_PCA(int i_width, int i_height) {
        super(i_width, i_height);
    }

    public NyARMatchPatt_Color_WITH_PCA(NyARCode i_code_ref) {
        super(i_code_ref);
    }

    @Override
    public boolean evaluate(NyARMatchPattDeviationColorData i_patt, NyARMatchPattResult o_result) throws NyARException {
        int[] linput = i_patt.refData();
        double max = 0.0;
        int res = -1;
        double[] invec = new double[10];
        int i = 0;
        while (i < this.evec_dim) {
            invec[i] = 0.0;
            int j = 0;
            while (j < this._rgbpixels) {
                int n = i;
                invec[n] = invec[n] + this.evec[i][j] * (double)linput[j];
                ++i;
            }
            int n = i++;
            invec[n] = invec[n] / i_patt.getPow();
        }
        double min = 10000.0;
        int j = 0;
        while (j < 4) {
            double sum2 = 0.0;
            int i2 = 0;
            while (i2 < this.evec_dim) {
                sum2 += (invec[i2] - this.epat[j][i2]) * (invec[i2] - this.epat[j][i2]);
                ++i2;
            }
            if (sum2 < min) {
                min = sum2;
                res = j;
            }
            ++j;
        }
        int sum = 0;
        int[] code_data = this._code_patt.getColorData(res).refData();
        int i3 = 0;
        while (i3 < this._rgbpixels) {
            sum += linput[i3] * code_data[i3];
            ++i3;
        }
        max = (double)sum / this._code_patt.getColorData(res).getPow() / i_patt.getPow();
        o_result.direction = res;
        o_result.confidence = max;
        return true;
    }
}

