/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.transmat.optimize.artoolkit.INyARRotMatrixOptimize;
import jp.nyatla.nyartoolkit.core.transmat.optimize.artoolkit.NyARRotMatrixOptimize_O2;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix_ARToolKit;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix_ARToolKit_O2;
import jp.nyatla.nyartoolkit.core.transmat.solver.INyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.transmat.solver.NyARTransportVectorSolver_ARToolKit;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;

public class NyARTransMat_ARToolKit
implements INyARTransMat {
    private static final int AR_GET_TRANS_MAT_MAX_LOOP_COUNT = 5;
    private static final double AR_GET_TRANS_MAT_MAX_FIT_ERROR = 1.0;
    private static final double AR_GET_TRANS_CONT_MAT_MAX_FIT_ERROR = 1.0;
    protected NyARRotMatrix_ARToolKit _rotmatrix;
    protected INyARTransportVectorSolver _transsolver;
    protected INyARRotMatrixOptimize _mat_optimize;
    private NyARCameraDistortionFactor _ref_dist_factor;
    private final NyARDoublePoint2d[] __transMat_vertex_2d = NyARDoublePoint2d.createArray(4);
    private final NyARDoublePoint3d[] __transMat_vertex_3d = NyARDoublePoint3d.createArray(4);
    private final NyARDoublePoint3d __transMat_trans = new NyARDoublePoint3d();

    protected NyARTransMat_ARToolKit() {
    }

    public NyARTransMat_ARToolKit(NyARCameraDistortionFactor i_ref_distfactor, NyARPerspectiveProjectionMatrix i_ref_projmat) throws NyARException {
        this.initInstance(i_ref_distfactor, i_ref_projmat);
    }

    public NyARTransMat_ARToolKit(NyARParam i_param) throws NyARException {
        this.initInstance(i_param.getDistortionFactor(), i_param.getPerspectiveProjectionMatrix());
    }

    private void initInstance(NyARCameraDistortionFactor i_ref_distfactor, NyARPerspectiveProjectionMatrix i_ref_projmat) throws NyARException {
        NyARCameraDistortionFactor dist = i_ref_distfactor;
        NyARPerspectiveProjectionMatrix pmat = i_ref_projmat;
        this._transsolver = new NyARTransportVectorSolver_ARToolKit(pmat);
        this._rotmatrix = new NyARRotMatrix_ARToolKit_O2(pmat);
        this._mat_optimize = new NyARRotMatrixOptimize_O2(pmat);
        this._ref_dist_factor = dist;
    }

    @Override
    public final void transMat(NyARSquare i_square, NyARRectOffset i_offset, NyARTransMatResult o_result_conv) throws NyARException {
        NyARDoublePoint2d[] vertex_2d;
        NyARDoublePoint3d trans = this.__transMat_trans;
        if (this._ref_dist_factor != null) {
            vertex_2d = this.__transMat_vertex_2d;
            this._ref_dist_factor.ideal2ObservBatch(i_square.sqvertex, vertex_2d, 4);
        } else {
            vertex_2d = i_square.sqvertex;
        }
        this._transsolver.set2dVertex(vertex_2d, 4);
        this._rotmatrix.initRotBySquare(i_square.line, i_square.sqvertex);
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
        this._transsolver.solveTransportVector(vertex_3d, trans);
        double err = this.optimize(this._rotmatrix, trans, this._transsolver, i_offset.vertex, vertex_2d);
        o_result_conv.setValue(this._rotmatrix, trans, err);
    }

    @Override
    public final void transMatContinue(NyARSquare i_square, NyARRectOffset i_offset, NyARTransMatResult i_prev_result, NyARTransMatResult o_result) throws NyARException {
        NyARDoublePoint2d[] vertex_2d;
        NyARDoublePoint3d trans = this.__transMat_trans;
        if (!i_prev_result.has_value) {
            this.transMat(i_square, i_offset, o_result);
            return;
        }
        if (this._ref_dist_factor != null) {
            vertex_2d = this.__transMat_vertex_2d;
            this._ref_dist_factor.ideal2ObservBatch(i_square.sqvertex, vertex_2d, 4);
        } else {
            vertex_2d = i_square.sqvertex;
        }
        this._transsolver.set2dVertex(vertex_2d, 4);
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        this._rotmatrix.initRotByPrevResult(i_prev_result);
        this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
        this._transsolver.solveTransportVector(vertex_3d, trans);
        double err = this.optimize(this._rotmatrix, trans, this._transsolver, i_offset.vertex, vertex_2d);
        o_result.setValue(this._rotmatrix, trans, err);
        if (err > 1.0) {
            this._rotmatrix.initRotBySquare(i_square.line, i_square.sqvertex);
            this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
            this._transsolver.solveTransportVector(vertex_3d, trans);
            double err2 = this.optimize(this._rotmatrix, trans, this._transsolver, i_offset.vertex, vertex_2d);
            if (err2 < err) {
                o_result.setValue(this._rotmatrix, trans, err2);
            }
            err = err2;
        }
    }

    private double optimize(NyARRotMatrix_ARToolKit io_rotmat, NyARDoublePoint3d io_transvec, INyARTransportVectorSolver i_solver, NyARDoublePoint3d[] i_offset_3d, NyARDoublePoint2d[] i_2d_vertex) throws NyARException {
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        double err = -1.0;
        int i = 0;
        while (true) {
            err = this._mat_optimize.modifyMatrix(io_rotmat, io_transvec, i_offset_3d, i_2d_vertex);
            io_rotmat.getPoint3dBatch(i_offset_3d, vertex_3d, 4);
            i_solver.solveTransportVector(vertex_3d, io_transvec);
            err = this._mat_optimize.modifyMatrix(io_rotmat, io_transvec, i_offset_3d, i_2d_vertex);
            if (err < 1.0 || i == 4) break;
            io_rotmat.getPoint3dBatch(i_offset_3d, vertex_3d, 4);
            i_solver.solveTransportVector(vertex_3d, io_transvec);
            ++i;
        }
        return err;
    }
}

