/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_Perspective;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterArtkTh;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.detector.NyARDetectMarkerResult;
import jp.nyatla.nyartoolkit.detector.NyARDetectMarkerResultStack;

public class NyARDetectMarker {
    private INyARTransMat _transmat;
    private static final int AR_SQUARE_MAX = 300;
    private boolean _is_continue = false;
    private RleDetector _square_detect;
    private NyARRectOffset[] _offset;
    private NyARBinRaster _bin_raster;
    private INyARRgb2GsFilterArtkTh _tobin_filter;
    private INyARRgbRaster _last_input_raster = null;

    public NyARDetectMarker(NyARParam i_param, NyARCode[] i_code, double[] i_marker_width, int i_number_of_code) throws NyARException {
        this.initInstance(i_param, i_code, i_marker_width, i_number_of_code);
    }

    protected void initInstance(NyARParam i_ref_param, NyARCode[] i_ref_code, double[] i_marker_width, int i_number_of_code) throws NyARException {
        NyARIntSize scr_size = i_ref_param.getScreenSize();
        int cw = i_ref_code[0].getWidth();
        int ch = i_ref_code[0].getHeight();
        this._transmat = new NyARTransMat(i_ref_param);
        this._square_detect = new RleDetector(new NyARColorPatt_Perspective(cw, ch, 4, 25), i_ref_code, i_number_of_code, i_ref_param);
        this._offset = NyARRectOffset.createArray(i_number_of_code);
        int i = 0;
        while (i < i_number_of_code) {
            this._offset[i].setSquare(i_marker_width[i]);
            ++i;
        }
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
    }

    public int detectMarkerLite(INyARRgbRaster i_raster, int i_threshold) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize())) {
            throw new NyARException();
        }
        if (this._last_input_raster != i_raster) {
            this._tobin_filter = (INyARRgb2GsFilterArtkTh)i_raster.createInterface(INyARRgb2GsFilterArtkTh.class);
            this._last_input_raster = i_raster;
        }
        this._tobin_filter.doFilter(i_threshold, this._bin_raster);
        this._square_detect.init(i_raster);
        this._square_detect.detectMarker(this._bin_raster, 0);
        return this._square_detect.result_stack.getLength();
    }

    public void getTransmationMatrix(int i_index, NyARTransMatResult o_result) throws NyARException {
        NyARDetectMarkerResult result = (NyARDetectMarkerResult)this._square_detect.result_stack.getItem(i_index);
        if (this._is_continue) {
            this._transmat.transMatContinue(result.square, this._offset[result.arcode_id], o_result, o_result);
        } else {
            this._transmat.transMat(result.square, this._offset[result.arcode_id], o_result);
        }
    }

    public double getConfidence(int i_index) {
        return ((NyARDetectMarkerResult)this._square_detect.result_stack.getItem((int)i_index)).confidence;
    }

    public int getARCodeIndex(int i_index) {
        return ((NyARDetectMarkerResult)this._square_detect.result_stack.getItem((int)i_index)).arcode_id;
    }

    public void setContinueMode(boolean i_is_continue) {
        this._is_continue = i_is_continue;
    }

    private class RleDetector
    extends NyARSquareContourDetector_Rle {
        public NyARDetectMarkerResultStack result_stack;
        public INyARRgbRaster _ref_raster;
        private INyARColorPatt _inst_patt;
        private NyARMatchPattDeviationColorData _deviation_data;
        private NyARMatchPatt_Color_WITHOUT_PCA[] _match_patt;
        private final NyARMatchPattResult __detectMarkerLite_mr;
        private NyARCoord2Linear _coordline;
        private NyARIntPoint2d[] __ref_vertex;

        public RleDetector(INyARColorPatt i_inst_patt, NyARCode[] i_ref_code, int i_num_of_code, NyARParam i_param) throws NyARException {
            super(i_param.getScreenSize());
            this.result_stack = new NyARDetectMarkerResultStack(300);
            this.__detectMarkerLite_mr = new NyARMatchPattResult();
            this.__ref_vertex = new NyARIntPoint2d[4];
            int cw = i_ref_code[0].getWidth();
            int ch = i_ref_code[0].getHeight();
            this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA[i_num_of_code];
            this._match_patt[0] = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code[0]);
            int i = 1;
            while (i < i_num_of_code) {
                if (cw != i_ref_code[i].getWidth() || ch != i_ref_code[i].getHeight()) {
                    throw new NyARException();
                }
                this._match_patt[i] = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code[i]);
                ++i;
            }
            this._inst_patt = i_inst_patt;
            this._coordline = new NyARCoord2Linear(i_param.getScreenSize(), i_param.getDistortionFactor());
            this._deviation_data = new NyARMatchPattDeviationColorData(cw, ch);
        }

        @Override
        protected void onSquareDetect(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
            NyARMatchPattResult mr = this.__detectMarkerLite_mr;
            NyARIntPoint2d[] vertex = this.__ref_vertex;
            vertex[0] = i_coord.items[i_vertex_index[0]];
            vertex[1] = i_coord.items[i_vertex_index[1]];
            vertex[2] = i_coord.items[i_vertex_index[2]];
            vertex[3] = i_coord.items[i_vertex_index[3]];
            if (!this._inst_patt.pickFromRaster(this._ref_raster, vertex)) {
                return;
            }
            this._deviation_data.setRaster(this._inst_patt);
            this._match_patt[0].evaluate(this._deviation_data, mr);
            int square_index = 0;
            int direction = mr.direction;
            double confidence = mr.confidence;
            int i = 1;
            while (i < this._match_patt.length) {
                this._match_patt[i].evaluate(this._deviation_data, mr);
                if (!(confidence > mr.confidence)) {
                    square_index = i;
                    direction = mr.direction;
                    confidence = mr.confidence;
                }
                ++i;
            }
            NyARDetectMarkerResult result = (NyARDetectMarkerResult)this.result_stack.prePush();
            result.arcode_id = square_index;
            result.confidence = confidence;
            NyARSquare sq = result.square;
            int i2 = 0;
            while (i2 < 4) {
                int idx = (i2 + 4 - direction) % 4;
                this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coord, sq.line[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                if (!sq.line[i2].crossPos(sq.line[(i2 + 3) % 4], sq.sqvertex[i2])) {
                    throw new NyARException();
                }
                ++i2;
            }
        }

        public void init(INyARRgbRaster i_raster) {
            this._ref_raster = i_raster;
            this.result_stack.clear();
        }
    }
}

