/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.pixeldriver.NyARRgbPixelDriverFactory;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARPerspectiveCopyFactory;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARColorPatt_Base
implements INyARColorPatt {
    protected static final int AR_PATT_SAMPLE_NUM = 64;
    protected static final int BUFFER_FORMAT = 262402;
    protected static final double[][] CPARAM_WORLD = new double[][]{{100.0, 100.0}, {110.0, 100.0}, {110.0, 110.0}, {100.0, 110.0}};
    protected NyARIntSize _size;
    protected int[] _patdata;
    protected INyARRgbPixelDriver _pixelreader;

    public NyARColorPatt_Base(int i_width, int i_height) throws NyARException {
        assert (i_width <= 64 && i_height <= 64);
        this._size = new NyARIntSize(i_width, i_height);
        this._patdata = new int[i_height * i_width];
        this._pixelreader = NyARRgbPixelDriverFactory.createDriver(this);
    }

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final INyARRgbPixelDriver getRgbPixelDriver() {
        return this._pixelreader;
    }

    @Override
    public Object getBuffer() {
        return this._patdata;
    }

    @Override
    public boolean hasBuffer() {
        return this._patdata != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public final int getBufferType() {
        return 262402;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return 262402 == i_type_value;
    }

    private boolean get_cpara(NyARIntPoint2d[] i_vertex, NyARMat o_para) throws NyARException {
        double[][] world = CPARAM_WORLD;
        NyARMat a = new NyARMat(8, 8);
        double[][] a_array = a.getArray();
        NyARMat b = new NyARMat(8, 1);
        double[][] b_array = b.getArray();
        int i = 0;
        while (i < 4) {
            double[] a_pt0 = a_array[i * 2];
            double[] a_pt1 = a_array[i * 2 + 1];
            double[] world_pti = world[i];
            a_pt0[0] = world_pti[0];
            a_pt0[1] = world_pti[1];
            a_pt0[2] = 1.0;
            a_pt0[3] = 0.0;
            a_pt0[4] = 0.0;
            a_pt0[5] = 0.0;
            a_pt0[6] = -world_pti[0] * (double)i_vertex[i].x;
            a_pt0[7] = -world_pti[1] * (double)i_vertex[i].x;
            a_pt1[0] = 0.0;
            a_pt1[1] = 0.0;
            a_pt1[2] = 0.0;
            a_pt1[3] = world_pti[0];
            a_pt1[4] = world_pti[1];
            a_pt1[5] = 1.0;
            a_pt1[6] = -world_pti[0] * (double)i_vertex[i].y;
            a_pt1[7] = -world_pti[1] * (double)i_vertex[i].y;
            b_array[i * 2 + 0][0] = i_vertex[i].x;
            b_array[i * 2 + 1][0] = i_vertex[i].y;
            ++i;
        }
        if (!a.inverse()) {
            return false;
        }
        o_para.mul(a, b);
        return true;
    }

    @Override
    public boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertexs) throws NyARException {
        NyARMat cpara = new NyARMat(8, 1);
        if (!this.get_cpara(i_vertexs, cpara)) {
            return false;
        }
        double[][] para = cpara.getArray();
        double para00 = para[0][0];
        double para01 = para[1][0];
        double para02 = para[2][0];
        double para10 = para[3][0];
        double para11 = para[4][0];
        double para12 = para[5][0];
        double para20 = para[6][0];
        double para21 = para[7][0];
        double para22 = 1.0;
        int lx1 = (i_vertexs[0].x - i_vertexs[1].x) * (i_vertexs[0].x - i_vertexs[1].x) + (i_vertexs[0].y - i_vertexs[1].y) * (i_vertexs[0].y - i_vertexs[1].y);
        int lx2 = (i_vertexs[2].x - i_vertexs[3].x) * (i_vertexs[2].x - i_vertexs[3].x) + (i_vertexs[2].y - i_vertexs[3].y) * (i_vertexs[2].y - i_vertexs[3].y);
        int ly1 = (i_vertexs[1].x - i_vertexs[2].x) * (i_vertexs[1].x - i_vertexs[2].x) + (i_vertexs[1].y - i_vertexs[2].y) * (i_vertexs[1].y - i_vertexs[2].y);
        int ly2 = (i_vertexs[3].x - i_vertexs[0].x) * (i_vertexs[3].x - i_vertexs[0].x) + (i_vertexs[3].y - i_vertexs[0].y) * (i_vertexs[3].y - i_vertexs[0].y);
        if (lx2 > lx1) {
            lx1 = lx2;
        }
        if (ly2 > ly1) {
            ly1 = ly2;
        }
        int sample_pixel_x = this._size.w;
        int sample_pixel_y = this._size.h;
        while (sample_pixel_x * sample_pixel_x < lx1 / 4) {
            sample_pixel_x *= 2;
        }
        while (sample_pixel_y * sample_pixel_y < ly1 / 4) {
            sample_pixel_y *= 2;
        }
        if (sample_pixel_x > 64) {
            sample_pixel_x = 64;
        }
        if (sample_pixel_y > 64) {
            sample_pixel_y = 64;
        }
        int xdiv = sample_pixel_x / this._size.w;
        int ydiv = sample_pixel_y / this._size.h;
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        double xdiv2_reciprocal = 1.0 / (double)sample_pixel_x;
        double ydiv2_reciprocal = 1.0 / (double)sample_pixel_y;
        int[] rgb_tmp = new int[3];
        INyARRgbPixelDriver reader = image.getRgbPixelDriver();
        int xdiv_x_ydiv = xdiv * ydiv;
        int iy = 0;
        while (iy < this._size.h) {
            int ix = 0;
            while (ix < this._size.w) {
                int b = 0;
                int g = 0;
                int r = 0;
                int j = 0;
                while (j < ydiv) {
                    double yw = 102.5 + 5.0 * ((double)(iy * ydiv + j) + 0.5) * ydiv2_reciprocal;
                    int i = 0;
                    while (i < xdiv) {
                        double xw = 102.5 + 5.0 * ((double)(ix * xdiv + i) + 0.5) * xdiv2_reciprocal;
                        double d = para20 * xw + para21 * yw + 1.0;
                        if (d == 0.0) {
                            throw new NyARException();
                        }
                        int xc = (int)((para00 * xw + para01 * yw + para02) / d);
                        int yc = (int)((para10 * xw + para11 * yw + para12) / d);
                        if (xc >= 0 && xc < img_x && yc >= 0 && yc < img_y) {
                            reader.getPixel(xc, yc, rgb_tmp);
                            r += rgb_tmp[0];
                            g += rgb_tmp[1];
                            b += rgb_tmp[2];
                        }
                        ++i;
                    }
                    ++j;
                }
                this._patdata[iy * this._size.w + ix] = (r / xdiv_x_ydiv & 0xFF) << 16 | (g / xdiv_x_ydiv & 0xFF) << 8 | b / xdiv_x_ydiv & 0xFF;
                ++ix;
            }
            ++iy;
        }
        return true;
    }

    @Override
    public Object createInterface(Class<?> iIid) throws NyARException {
        if (iIid == INyARPerspectiveCopy.class) {
            return NyARPerspectiveCopyFactory.createDriver(this);
        }
        throw new NyARException();
    }
}

