/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.analyzer.histogram;

import jp.nyatla.nyartoolkit.core.analyzer.histogram.INyARHistogramAnalyzer_Threshold;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;

public class NyARHistogramAnalyzer_SlidePTile
implements INyARHistogramAnalyzer_Threshold {
    private int _persentage;

    public NyARHistogramAnalyzer_SlidePTile(int i_persentage) {
        assert (i_persentage >= 0 && i_persentage <= 50);
        this._persentage = i_persentage;
    }

    @Override
    public int getThreshold(NyARHistogram i_histogram) {
        int th_pixcels;
        int n = i_histogram.length;
        int sum_of_pixel = i_histogram.total_of_data;
        int[] hist = i_histogram.data;
        int th_wk = th_pixcels = sum_of_pixel * this._persentage / 100;
        int th_b = 0;
        while (th_b < n - 2) {
            if ((th_wk -= hist[th_b]) <= 0) break;
            ++th_b;
        }
        th_wk = th_pixcels;
        int th_w = n - 1;
        while (th_w > 1) {
            if ((th_wk -= hist[th_w]) <= 0) break;
            --th_w;
        }
        return (th_w + th_b) / 2;
    }
}

