/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.nyidmarker;

import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;

class MarkerPattEncoder {
    private static final int[] _bit_table_3;
    private static final int[] _bit_table_2;
    private static final int[][] _bit_tables;
    private int[] _bit_table;
    private int[] _bits = new int[16];
    private int[] _work = new int[16];
    private int _model;

    static {
        int[] nArray = new int[49];
        nArray[0] = 25;
        nArray[1] = 26;
        nArray[2] = 27;
        nArray[3] = 28;
        nArray[4] = 29;
        nArray[5] = 30;
        nArray[6] = 31;
        nArray[7] = 48;
        nArray[8] = 9;
        nArray[9] = 10;
        nArray[10] = 11;
        nArray[11] = 12;
        nArray[12] = 13;
        nArray[13] = 32;
        nArray[14] = 47;
        nArray[15] = 24;
        nArray[16] = 1;
        nArray[17] = 2;
        nArray[18] = 3;
        nArray[19] = 14;
        nArray[20] = 33;
        nArray[21] = 46;
        nArray[22] = 23;
        nArray[23] = 8;
        nArray[25] = 4;
        nArray[26] = 15;
        nArray[27] = 34;
        nArray[28] = 45;
        nArray[29] = 22;
        nArray[30] = 7;
        nArray[31] = 6;
        nArray[32] = 5;
        nArray[33] = 16;
        nArray[34] = 35;
        nArray[35] = 44;
        nArray[36] = 21;
        nArray[37] = 20;
        nArray[38] = 19;
        nArray[39] = 18;
        nArray[40] = 17;
        nArray[41] = 36;
        nArray[42] = 43;
        nArray[43] = 42;
        nArray[44] = 41;
        nArray[45] = 40;
        nArray[46] = 39;
        nArray[47] = 38;
        nArray[48] = 37;
        _bit_table_3 = nArray;
        int[] nArray2 = new int[25];
        nArray2[0] = 9;
        nArray2[1] = 10;
        nArray2[2] = 11;
        nArray2[3] = 12;
        nArray2[4] = 13;
        nArray2[5] = 24;
        nArray2[6] = 1;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 14;
        nArray2[10] = 23;
        nArray2[11] = 8;
        nArray2[13] = 4;
        nArray2[14] = 15;
        nArray2[15] = 22;
        nArray2[16] = 7;
        nArray2[17] = 6;
        nArray2[18] = 5;
        nArray2[19] = 16;
        nArray2[20] = 21;
        nArray2[21] = 20;
        nArray2[22] = 19;
        nArray2[23] = 18;
        nArray2[24] = 17;
        _bit_table_2 = nArray2;
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = _bit_table_2;
        nArrayArray[1] = _bit_table_3;
        _bit_tables = nArrayArray;
    }

    MarkerPattEncoder() {
    }

    public void setBitByBitIndex(int i_index_no, int i_value) {
        assert (i_value == 0 || i_value == 1);
        int bit_no = this._bit_table[i_index_no];
        if (bit_no == 0) {
            this._bits[0] = i_value;
        } else {
            int bidx = (bit_no - 1) / 8 + 1;
            int sidx = (bit_no - 1) % 8;
            this._bits[bidx] = this._bits[bidx] & ~(1 << sidx) | i_value << sidx;
        }
    }

    public void setBit(int i_bit_no, int i_value) {
        assert (i_value == 0 || i_value == 1);
        if (i_bit_no == 0) {
            this._bits[0] = i_value;
        } else {
            int bidx = (i_bit_no - 1) / 8 + 1;
            int sidx = (i_bit_no - 1) % 8;
            this._bits[bidx] = this._bits[bidx] & ~(1 << sidx) | i_value << sidx;
        }
    }

    public int getBit(int i_bit_no) {
        if (i_bit_no == 0) {
            return this._bits[0];
        }
        int bidx = (i_bit_no - 1) / 8 + 1;
        int sidx = (i_bit_no - 1) % 8;
        return this._bits[bidx] >> sidx & 1;
    }

    public int getModel() {
        return this._model;
    }

    private static int getControlValue(int i_model, int[] i_data) {
        switch (i_model) {
            case 2: {
                int v = (i_data[2] & 0xE) >> 1;
                return v >= 5 ? v - 1 : v;
            }
            case 3: {
                int v = (i_data[4] & 0x3E) >> 1;
                return v >= 21 ? v - 1 : v;
            }
        }
        return -1;
    }

    private static int getCheckValue(int i_model, int[] i_data) {
        switch (i_model) {
            case 2: {
                int v = (i_data[2] & 0xE0) >> 5;
                return v > 5 ? v - 1 : v;
            }
            case 3: {
                int v = (i_data[4] & 0x80) >> 7 | (i_data[5] & 0xF) << 1;
                return v > 21 ? v - 1 : v;
            }
        }
        return -1;
    }

    public boolean initEncoder(int i_model) {
        if (i_model > 3 || i_model < 2) {
            return false;
        }
        this._bit_table = _bit_tables[i_model - 2];
        this._model = i_model;
        return true;
    }

    private int getDirection() {
        int timing_pat;
        int l;
        int b;
        int r;
        int t;
        switch (this._model) {
            case 2: {
                t = this._bits[2] & 0x1F;
                r = (this._bits[2] & 0xF0) >> 4 | (this._bits[3] & 1) << 4;
                b = this._bits[3] & 0x1F;
                l = (this._bits[3] & 0xF0) >> 4 | (this._bits[2] & 1) << 4;
                timing_pat = 10;
                break;
            }
            case 3: {
                t = this._bits[4] & 0x7F;
                r = (this._bits[4] & 0xC0) >> 6 | (this._bits[5] & 0x1F) << 2;
                b = (this._bits[5] & 0xF0) >> 4 | (this._bits[6] & 7) << 4;
                l = (this._bits[6] & 0xFC) >> 2 | (this._bits[4] & 1) << 6;
                timing_pat = 42;
                break;
            }
            default: {
                return -3;
            }
        }
        if (t == timing_pat) {
            if (r == timing_pat) {
                return b != timing_pat && l != timing_pat ? 2 : -2;
            }
            if (l == timing_pat) {
                return b != timing_pat && r != timing_pat ? 3 : -2;
            }
        } else if (b == timing_pat) {
            if (r == timing_pat) {
                return t != timing_pat && l != timing_pat ? 1 : -2;
            }
            if (l == timing_pat) {
                return t != timing_pat && r != timing_pat ? 0 : -2;
            }
        }
        return -1;
    }

    public int encode(NyIdMarkerPattern o_out) {
        int model;
        int d = this.getDirection();
        if (d < 0) {
            return -1;
        }
        this.getRotatedBits(d, o_out.data);
        o_out.model = model = this._model;
        int control_bits = MarkerPattEncoder.getControlValue(model, o_out.data);
        o_out.check = MarkerPattEncoder.getCheckValue(model, o_out.data);
        o_out.ctrl_mask = control_bits % 5;
        o_out.ctrl_domain = control_bits / 5;
        if (o_out.ctrl_domain != 0 || o_out.ctrl_mask != 0) {
            return -1;
        }
        return d;
    }

    private void getRotatedBits(int i_direction, int[] o_out) {
        int sl = i_direction * 2;
        int sr = 8 - sl;
        o_out[0] = this._bits[0];
        int w1 = this._bits[1];
        o_out[1] = (w1 << sl | w1 >> sr) & 0xFF;
        sl = i_direction * 4;
        sr = 16 - sl;
        w1 = this._bits[2] | this._bits[3] << 8;
        w1 = w1 << sl | w1 >> sr;
        o_out[2] = w1 & 0xFF;
        o_out[3] = w1 >> 8 & 0xFF;
        if (this._model < 2) {
            return;
        }
        sl = i_direction * 6;
        sr = 24 - sl;
        w1 = this._bits[4] | this._bits[5] << 8 | this._bits[6] << 16;
        w1 = w1 << sl | w1 >> sr;
        o_out[4] = w1 & 0xFF;
        o_out[5] = w1 >> 8 & 0xFF;
        o_out[6] = w1 >> 16 & 0xFF;
        if (this._model < 3) {
            return;
        }
    }

    public void shiftLeft(int[] i_pack, int i_start, int i_length, int i_ls) {
        int[] work = this._work;
        int mod_shift = i_ls % 8;
        int i = i_length - 1;
        while (i >= 1) {
            work[i] = i_pack[i + i_start] << mod_shift | 0xFF & i_pack[i + i_start - 1] >> 8 - mod_shift;
            --i;
        }
        work[0] = i_pack[i_start] << mod_shift | 0xFF & i_pack[i_start + i_length - 1] >> 8 - mod_shift;
        int byte_shift = i_ls / 8 % i_length;
        int i2 = i_length - 1;
        while (i2 >= 0) {
            i_pack[(byte_shift + i2) % i_length + i_start] = 0xFF & work[i2];
            --i2;
        }
    }
}

