/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARFrustum;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.stack.NyARPointerStack;
import jp.nyatla.nyartoolkit.markersystem.INyARSingleCameraSystemObserver;

public class NyARSingleCameraSystem {
    public static final double FRUSTUM_DEFAULT_FAR_CLIP = 10000.0;
    public static final double FRUSTUM_DEFAULT_NEAR_CLIP = 10.0;
    protected NyARParam _ref_param;
    protected NyARFrustum _frustum;
    protected ObserverList _observer = new ObserverList(3);

    protected NyARSingleCameraSystem(NyARParam i_ref_cparam) throws NyARException {
        this._ref_param = i_ref_cparam;
        this._frustum = new NyARFrustum();
        this.setProjectionMatrixClipping(10.0, 10000.0);
    }

    public NyARFrustum getFrustum() {
        return this._frustum;
    }

    public NyARParam getARParam() {
        return this._ref_param;
    }

    public void setProjectionMatrixClipping(double i_near, double i_far) {
        NyARIntSize s = this._ref_param.getScreenSize();
        this._frustum.setValue(this._ref_param.getPerspectiveProjectionMatrix(), s.w, s.h, i_near, i_far);
        this._observer.notifyOnUpdateCameraParametor(this._ref_param, i_near, i_far);
    }

    public void addObserver(INyARSingleCameraSystemObserver i_observer) {
        this._observer.pushAssert(i_observer);
        NyARFrustum.FrustumParam f = this.getFrustum().getFrustumParam(new NyARFrustum.FrustumParam());
        i_observer.onUpdateCameraParametor(this._ref_param, f.near, f.far);
    }

    protected class ObserverList
    extends NyARPointerStack<INyARSingleCameraSystemObserver> {
        public ObserverList(int i_length) throws NyARException {
            super.initInstance(i_length, INyARSingleCameraSystemObserver.class);
        }

        public void notifyOnUpdateCameraParametor(NyARParam i_param, double i_near, double i_far) {
            int i = 0;
            while (i < this._length) {
                ((INyARSingleCameraSystemObserver[])this._items)[i].onUpdateCameraParametor(i_param, i_near, i_far);
                ++i;
            }
        }
    }
}

