/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.utils;

public class NyARSystemOfLinearEquationsProcessor {
    private static boolean isValid2dArray(double[][] i_left, double[] i_right) {
        int sm = i_left.length;
        int sn = i_left[0].length;
        if (i_left.length != sm) {
            return false;
        }
        if (i_right.length != sm) {
            return false;
        }
        int i = 1;
        while (i < sm) {
            if (i_left[i].length != sn) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean doGaussianElimination(double[][] i_left, double[] i_right, int i_n, int i_m) {
        assert (NyARSystemOfLinearEquationsProcessor.isValid2dArray(i_left, i_right));
        int solve_row = 0;
        while (solve_row < i_m) {
            int pivod = solve_row;
            double pivod_value = Math.abs(i_left[pivod][pivod]);
            int i = solve_row + 1;
            while (i < i_m) {
                double pivod_2 = Math.abs(i_left[i][pivod]);
                if (pivod_value < Math.abs(pivod_2)) {
                    pivod = i;
                    pivod_value = pivod_2;
                }
                ++i;
            }
            if (solve_row != pivod) {
                double[] t = i_left[solve_row];
                i_left[solve_row] = i_left[pivod];
                i_left[pivod] = t;
                double t2 = i_right[solve_row];
                i_right[solve_row] = i_right[pivod];
                i_right[pivod] = t2;
            }
            double[] dest_l_n = i_left[solve_row];
            double dest_l_nn = i_left[solve_row][solve_row];
            if (dest_l_nn == 0.0) {
                return false;
            }
            i = 0;
            while (i < solve_row) {
                double s = dest_l_n[i];
                int i2 = 0;
                while (i2 < i_n) {
                    double p = i_left[i][i2] * s;
                    dest_l_n[i2] = dest_l_n[i2] - p;
                    ++i2;
                }
                double k = i_right[i] * s;
                i_right[solve_row] = i_right[solve_row] - k;
                ++i;
            }
            double d = dest_l_n[solve_row];
            int i2 = 0;
            while (i2 < solve_row) {
                dest_l_n[i2] = 0.0;
                ++i2;
            }
            if (d != 1.0) {
                dest_l_n[solve_row] = 1.0;
                int i3 = solve_row + 1;
                while (i3 < i_n) {
                    int n = i3++;
                    dest_l_n[n] = dest_l_n[n] / d;
                }
                int n = solve_row;
                i_right[n] = i_right[n] / d;
            }
            ++solve_row;
        }
        return true;
    }

    public static boolean solve(double[][] i_left, double[] i_right, int i_number_of_system) {
        return NyARSystemOfLinearEquationsProcessor.doGaussianElimination(i_left, i_right, i_number_of_system, i_number_of_system);
    }
}

