/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

public class NyARHistogram {
    public final int[] data;
    public int length;
    public int total_of_data;

    public NyARHistogram(int i_length) {
        this.data = new int[i_length];
        this.length = i_length;
        this.total_of_data = 0;
    }

    public int getTotal(int i_st, int i_ed) {
        assert (i_st < i_ed && i_ed < this.length);
        int result = 0;
        int[] s = this.data;
        int i = i_st;
        while (i <= i_ed) {
            result += s[i];
            ++i;
        }
        return result;
    }

    public void lowCut(int i_pos) {
        int s = 0;
        int i = 0;
        while (i < i_pos) {
            s += this.data[i];
            this.data[i] = 0;
            ++i;
        }
        this.total_of_data -= s;
    }

    public void highCut(int i_pos) {
        int s = 0;
        int i = this.length - 1;
        while (i >= i_pos) {
            s += this.data[i];
            this.data[i] = 0;
            --i;
        }
        this.total_of_data -= s;
    }

    public int getMinSample() {
        int[] data = this.data;
        int ret = this.length - 1;
        int min = data[ret];
        int i = this.length - 2;
        while (i >= 0) {
            if (data[i] < min) {
                min = data[i];
                ret = i;
            }
            --i;
        }
        return ret;
    }

    public int getMinData() {
        return this.data[this.getMinSample()];
    }

    public int getAverage() {
        long sum = 0L;
        int i = this.length - 1;
        while (i >= 0) {
            sum += (long)(this.data[i] * i);
            --i;
        }
        return (int)(sum / (long)this.total_of_data);
    }
}

