/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.optimize;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.optimize.TSinCosValue;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix33;
import jp.nyatla.nyartoolkit.core.utils.NyAREquationSolver;

public class NyARPartialDifferentiationOptimize {
    private final NyARPerspectiveProjectionMatrix _projection_mat_ref;
    private TSinCosValue[] __angles_in = TSinCosValue.createArray(3);
    private NyARDoublePoint3d __ang = new NyARDoublePoint3d();
    private double[] __sin_table = new double[4];

    public NyARPartialDifferentiationOptimize(NyARPerspectiveProjectionMatrix i_projection_mat_ref) {
        this._projection_mat_ref = i_projection_mat_ref;
    }

    public final void sincos2Rotation_ZXY(TSinCosValue[] i_sincos, NyARDoubleMatrix33 i_rot_matrix) {
        double sina = i_sincos[0].sin_val;
        double cosa = i_sincos[0].cos_val;
        double sinb = i_sincos[1].sin_val;
        double cosb = i_sincos[1].cos_val;
        double sinc = i_sincos[2].sin_val;
        double cosc = i_sincos[2].cos_val;
        i_rot_matrix.m00 = cosc * cosb - sinc * sina * sinb;
        i_rot_matrix.m01 = -sinc * cosa;
        i_rot_matrix.m02 = cosc * sinb + sinc * sina * cosb;
        i_rot_matrix.m10 = sinc * cosb + cosc * sina * sinb;
        i_rot_matrix.m11 = cosc * cosa;
        i_rot_matrix.m12 = sinc * sinb - cosc * sina * cosb;
        i_rot_matrix.m20 = -cosa * sinb;
        i_rot_matrix.m21 = sina;
        i_rot_matrix.m22 = cosb * cosa;
    }

    private final void rotation2Sincos_ZXY(NyARDoubleMatrix33 i_rot_matrix, TSinCosValue[] o_out, NyARDoublePoint3d o_ang) {
        double z;
        double y;
        double x;
        double sina = i_rot_matrix.m21;
        if (sina >= 1.0) {
            x = 1.5707963267948966;
            y = 0.0;
            z = Math.atan2(-i_rot_matrix.m10, i_rot_matrix.m00);
        } else if (sina <= -1.0) {
            x = -1.5707963267948966;
            y = 0.0;
            z = Math.atan2(-i_rot_matrix.m10, i_rot_matrix.m00);
        } else {
            x = Math.asin(sina);
            y = Math.atan2(-i_rot_matrix.m20, i_rot_matrix.m22);
            z = Math.atan2(-i_rot_matrix.m01, i_rot_matrix.m11);
        }
        o_ang.x = x;
        o_ang.y = y;
        o_ang.z = z;
        o_out[0].sin_val = Math.sin(x);
        o_out[0].cos_val = Math.cos(x);
        o_out[1].sin_val = Math.sin(y);
        o_out[1].cos_val = Math.cos(y);
        o_out[2].sin_val = Math.sin(z);
        o_out[2].cos_val = Math.cos(z);
    }

    private double optimizeParamX(TSinCosValue i_angle_y, TSinCosValue i_angle_z, NyARDoublePoint3d i_trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d, int i_number_of_vertex, double i_hint_angle) throws NyARException {
        NyARPerspectiveProjectionMatrix cp = this._projection_mat_ref;
        double sinb = i_angle_y.sin_val;
        double cosb = i_angle_y.cos_val;
        double sinc = i_angle_z.sin_val;
        double cosc = i_angle_z.cos_val;
        double O = 0.0;
        double N = 0.0;
        double M = 0.0;
        double K = 0.0;
        double J = 0.0;
        double L = 0.0;
        int i = 0;
        while (i < i_number_of_vertex) {
            double ix = i_vertex3d[i].x;
            double iy = i_vertex3d[i].y;
            double iz = i_vertex3d[i].z;
            double cp00 = cp.m00;
            double cp01 = cp.m01;
            double cp02 = cp.m02;
            double cp11 = cp.m11;
            double cp12 = cp.m12;
            double X0 = cp00 * (-sinc * sinb * ix + sinc * cosb * iz) + cp01 * (cosc * sinb * ix - cosc * cosb * iz) + cp02 * iy;
            double X1 = cp00 * (-sinc * iy) + cp01 * (cosc * iy) + cp02 * (-sinb * ix + cosb * iz);
            double X2 = cp00 * (i_trans.x + cosc * cosb * ix + cosc * sinb * iz) + cp01 * (i_trans.y + sinc * cosb * ix + sinc * sinb * iz) + cp02 * i_trans.z;
            double Y0 = cp11 * (cosc * sinb * ix - cosc * cosb * iz) + cp12 * iy;
            double Y1 = cp11 * (cosc * iy) + cp12 * (-sinb * ix + cosb * iz);
            double Y2 = cp11 * (i_trans.y + sinc * cosb * ix + sinc * sinb * iz) + cp12 * i_trans.z;
            double H0 = iy;
            double H1 = -sinb * ix + cosb * iz;
            double H2 = i_trans.z;
            double VX = i_vertex2d[i].x;
            double VY = i_vertex2d[i].y;
            double a = VX * H0 - X0;
            double b = VX * H1 - X1;
            double c = VX * H2 - X2;
            double d = VY * H0 - Y0;
            double e = VY * H1 - Y1;
            double f = VY * H2 - Y2;
            L += d * e + a * b;
            N += d * d + a * a;
            J += d * f + a * c;
            M += e * e + b * b;
            K += e * f + b * c;
            O += f * f + c * c;
            ++i;
        }
        return this.getMinimumErrorAngleFromParam(L *= 2.0, J *= 2.0, K *= 2.0, M, N, O, i_hint_angle);
    }

    private double optimizeParamY(TSinCosValue i_angle_x, TSinCosValue i_angle_z, NyARDoublePoint3d i_trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d, int i_number_of_vertex, double i_hint_angle) throws NyARException {
        NyARPerspectiveProjectionMatrix cp = this._projection_mat_ref;
        double sina = i_angle_x.sin_val;
        double cosa = i_angle_x.cos_val;
        double sinc = i_angle_z.sin_val;
        double cosc = i_angle_z.cos_val;
        double O = 0.0;
        double N = 0.0;
        double M = 0.0;
        double K = 0.0;
        double J = 0.0;
        double L = 0.0;
        int i = 0;
        while (i < i_number_of_vertex) {
            double ix = i_vertex3d[i].x;
            double iy = i_vertex3d[i].y;
            double iz = i_vertex3d[i].z;
            double cp00 = cp.m00;
            double cp01 = cp.m01;
            double cp02 = cp.m02;
            double cp11 = cp.m11;
            double cp12 = cp.m12;
            double X0 = cp00 * (-sinc * sina * ix + cosc * iz) + cp01 * (cosc * sina * ix + sinc * iz) + cp02 * (-cosa * ix);
            double X1 = cp01 * (sinc * ix - cosc * sina * iz) + cp00 * (cosc * ix + sinc * sina * iz) + cp02 * (cosa * iz);
            double X2 = cp00 * (i_trans.x + -sinc * cosa * iy) + cp01 * (i_trans.y + cosc * cosa * iy) + cp02 * (i_trans.z + sina * iy);
            double Y0 = cp11 * (cosc * sina * ix + sinc * iz) + cp12 * (-cosa * ix);
            double Y1 = cp11 * (sinc * ix - cosc * sina * iz) + cp12 * (cosa * iz);
            double Y2 = cp11 * (i_trans.y + cosc * cosa * iy) + cp12 * (i_trans.z + sina * iy);
            double H0 = -cosa * ix;
            double H1 = cosa * iz;
            double H2 = i_trans.z + sina * iy;
            double VX = i_vertex2d[i].x;
            double VY = i_vertex2d[i].y;
            double a = VX * H0 - X0;
            double b = VX * H1 - X1;
            double c = VX * H2 - X2;
            double d = VY * H0 - Y0;
            double e = VY * H1 - Y1;
            double f = VY * H2 - Y2;
            L += d * e + a * b;
            N += d * d + a * a;
            J += d * f + a * c;
            M += e * e + b * b;
            K += e * f + b * c;
            O += f * f + c * c;
            ++i;
        }
        return this.getMinimumErrorAngleFromParam(L *= 2.0, J *= 2.0, K *= 2.0, M, N, O, i_hint_angle);
    }

    private double optimizeParamZ(TSinCosValue i_angle_x, TSinCosValue i_angle_y, NyARDoublePoint3d i_trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d, int i_number_of_vertex, double i_hint_angle) throws NyARException {
        NyARPerspectiveProjectionMatrix cp = this._projection_mat_ref;
        double sina = i_angle_x.sin_val;
        double cosa = i_angle_x.cos_val;
        double sinb = i_angle_y.sin_val;
        double cosb = i_angle_y.cos_val;
        double O = 0.0;
        double N = 0.0;
        double M = 0.0;
        double K = 0.0;
        double J = 0.0;
        double L = 0.0;
        int i = 0;
        while (i < i_number_of_vertex) {
            double ix = i_vertex3d[i].x;
            double iy = i_vertex3d[i].y;
            double iz = i_vertex3d[i].z;
            double cp00 = cp.m00;
            double cp01 = cp.m01;
            double cp02 = cp.m02;
            double cp11 = cp.m11;
            double cp12 = cp.m12;
            double X0 = cp00 * (-sina * sinb * ix - cosa * iy + sina * cosb * iz) + cp01 * (ix * cosb + sinb * iz);
            double X1 = cp01 * (sina * ix * sinb + cosa * iy - sina * iz * cosb) + cp00 * (cosb * ix + sinb * iz);
            double X2 = cp00 * i_trans.x + cp01 * i_trans.y + cp02 * (-cosa * sinb) * ix + cp02 * sina * iy + cp02 * (cosb * cosa * iz + i_trans.z);
            double Y0 = cp11 * (ix * cosb + sinb * iz);
            double Y1 = cp11 * (sina * ix * sinb + cosa * iy - sina * iz * cosb);
            double Y2 = cp11 * i_trans.y + cp12 * (-cosa * sinb) * ix + cp12 * (sina * iy + cosb * cosa * iz + i_trans.z);
            double H0 = 0.0;
            double H1 = 0.0;
            double H2 = -cosa * sinb * ix + sina * iy + cosb * cosa * iz + i_trans.z;
            double VX = i_vertex2d[i].x;
            double VY = i_vertex2d[i].y;
            double a = VX * H0 - X0;
            double b = VX * H1 - X1;
            double c = VX * H2 - X2;
            double d = VY * H0 - Y0;
            double e = VY * H1 - Y1;
            double f = VY * H2 - Y2;
            L += d * e + a * b;
            N += d * d + a * a;
            J += d * f + a * c;
            M += e * e + b * b;
            K += e * f + b * c;
            O += f * f + c * c;
            ++i;
        }
        return this.getMinimumErrorAngleFromParam(L *= 2.0, J *= 2.0, K *= 2.0, M, N, O, i_hint_angle);
    }

    public void modifyMatrix(NyARDoubleMatrix33 io_rot, NyARDoublePoint3d i_trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d, int i_number_of_vertex) throws NyARException {
        TSinCosValue[] angles_in = this.__angles_in;
        NyARDoublePoint3d ang = this.__ang;
        this.rotation2Sincos_ZXY(io_rot, angles_in, ang);
        ang.x += this.optimizeParamX(angles_in[1], angles_in[2], i_trans, i_vertex3d, i_vertex2d, i_number_of_vertex, ang.x);
        ang.y += this.optimizeParamY(angles_in[0], angles_in[2], i_trans, i_vertex3d, i_vertex2d, i_number_of_vertex, ang.y);
        ang.z += this.optimizeParamZ(angles_in[0], angles_in[1], i_trans, i_vertex3d, i_vertex2d, i_number_of_vertex, ang.z);
        io_rot.setZXYAngle(ang.x, ang.y, ang.z);
    }

    private double getMinimumErrorAngleFromParam(double iL, double iJ, double iK, double iM, double iN, double iO, double i_hint_angle) throws NyARException {
        double[] sin_table = this.__sin_table;
        double M = (iN - iM) / iL;
        double J = iJ / iL;
        double K = -iK / iL;
        int number_of_sin = NyAREquationSolver.solve4Equation(-4.0 * M * M - 4.0, 4.0 * K - 4.0 * J * M, 4.0 * M * M - (K * K - 4.0) - J * J, 4.0 * J * M - 2.0 * K, J * J - 1.0, sin_table);
        double min_ang_0 = Double.MAX_VALUE;
        double min_ang_1 = Double.MAX_VALUE;
        double min_err_0 = Double.MAX_VALUE;
        double min_err_1 = Double.MAX_VALUE;
        int i = 0;
        while (i < number_of_sin) {
            double sin_rt = sin_table[i];
            double cos_rt = Math.sqrt(1.0 - sin_rt * sin_rt);
            double a1 = 2.0 * cos_rt * sin_rt * M + sin_rt * (K - sin_rt) + cos_rt * (cos_rt + J);
            double a2 = 2.0 * -cos_rt * sin_rt * M + sin_rt * (K - sin_rt) + -cos_rt * (-cos_rt + J);
            a1 = a1 < 0.0 ? -a1 : a1;
            a2 = a2 < 0.0 ? -a2 : a2;
            cos_rt = a1 < a2 ? cos_rt : -cos_rt;
            double ang = Math.atan2(sin_rt, cos_rt);
            double err = iN * sin_rt * sin_rt + (iL * cos_rt + iJ) * sin_rt + iM * cos_rt * cos_rt + iK * cos_rt + iO;
            if (min_err_0 > err) {
                min_err_1 = min_err_0;
                min_ang_1 = min_ang_0;
                min_err_0 = err;
                min_ang_0 = ang;
            } else if (min_err_1 > err) {
                min_err_1 = err;
                min_ang_1 = ang;
            }
            ++i;
        }
        double gap_0 = min_ang_0 - i_hint_angle;
        if (gap_0 > Math.PI) {
            gap_0 = min_ang_0 - Math.PI * 2 - i_hint_angle;
        } else if (gap_0 < -Math.PI) {
            gap_0 = min_ang_0 + Math.PI * 2 - i_hint_angle;
        }
        double gap_1 = min_ang_1 - i_hint_angle;
        if (gap_1 > Math.PI) {
            gap_1 = min_ang_1 - Math.PI * 2 - i_hint_angle;
        } else if (gap_1 < -Math.PI) {
            gap_1 = min_ang_1 + Math.PI * 2 - i_hint_angle;
        }
        return Math.abs(gap_1) < Math.abs(gap_0) ? gap_1 : gap_0;
    }
}

