/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.transmat.optimize.NyARPartialDifferentiationOptimize;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.transmat.solver.INyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.transmat.solver.NyARTransportVectorSolver;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix33;

public class NyARTransMat
implements INyARTransMat {
    private NyARPerspectiveProjectionMatrix _projection_mat_ref;
    protected NyARRotMatrix _rotmatrix;
    protected INyARTransportVectorSolver _transsolver;
    protected NyARPartialDifferentiationOptimize _mat_optimize;
    private NyARCameraDistortionFactor _ref_dist_factor;
    private final NyARDoublePoint2d[] __transMat_vertex_2d = NyARDoublePoint2d.createArray(4);
    private final NyARDoublePoint3d[] __transMat_vertex_3d = NyARDoublePoint3d.createArray(4);
    private final NyARDoublePoint3d __transMat_trans = new NyARDoublePoint3d();
    private NyARDoubleMatrix33 __rot = new NyARDoubleMatrix33();

    protected NyARTransMat() {
    }

    public NyARTransMat(NyARParam i_param) throws NyARException {
        NyARCameraDistortionFactor dist = i_param.getDistortionFactor();
        NyARPerspectiveProjectionMatrix pmat = i_param.getPerspectiveProjectionMatrix();
        this._transsolver = new NyARTransportVectorSolver(pmat, 4);
        this._rotmatrix = new NyARRotMatrix(pmat);
        this._mat_optimize = new NyARPartialDifferentiationOptimize(pmat);
        this._ref_dist_factor = dist;
        this._projection_mat_ref = pmat;
    }

    private double makeErrThreshold(NyARDoublePoint2d[] i_vertex) {
        double a = i_vertex[0].x - i_vertex[2].x;
        double b = i_vertex[0].y - i_vertex[2].y;
        double l1 = a * a + b * b;
        double l2 = (a = i_vertex[1].x - i_vertex[3].x) * a + (b = i_vertex[1].y - i_vertex[3].y) * b;
        return Math.sqrt(l1 > l2 ? l1 : l2) / 200.0;
    }

    public void transMat(NyARSquare i_square, NyARRectOffset i_offset, NyARTransMatResult o_result_conv) throws NyARException {
        NyARDoublePoint3d trans = this.__transMat_trans;
        double err_threshold = this.makeErrThreshold(i_square.sqvertex);
        NyARDoublePoint2d[] vertex_2d = this.__transMat_vertex_2d;
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        this._ref_dist_factor.ideal2ObservBatch(i_square.sqvertex, vertex_2d, 4);
        this._transsolver.set2dVertex(vertex_2d, 4);
        this._rotmatrix.initRotBySquare(i_square.line, i_square.sqvertex);
        this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
        this._transsolver.solveTransportVector(vertex_3d, trans);
        o_result_conv.error = this.optimize(this._rotmatrix, trans, this._transsolver, i_offset.vertex, vertex_2d, err_threshold);
        this.updateMatrixValue(this._rotmatrix, trans, o_result_conv);
    }

    public void transMatContinue(NyARSquare i_square, NyARRectOffset i_offset, NyARTransMatResult o_result_conv) throws NyARException {
        NyARDoublePoint3d trans = this.__transMat_trans;
        if (!o_result_conv.has_value) {
            this.transMat(i_square, i_offset, o_result_conv);
            return;
        }
        double err_threshold = this.makeErrThreshold(i_square.sqvertex);
        NyARDoublePoint2d[] vertex_2d = this.__transMat_vertex_2d;
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        this._ref_dist_factor.ideal2ObservBatch(i_square.sqvertex, vertex_2d, 4);
        this._transsolver.set2dVertex(vertex_2d, 4);
        this._rotmatrix.initRotByPrevResult(o_result_conv);
        this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
        this._transsolver.solveTransportVector(vertex_3d, trans);
        double min_err = this.errRate(this._rotmatrix, trans, i_offset.vertex, vertex_2d, 4, vertex_3d);
        NyARDoubleMatrix33 rot = this.__rot;
        if (min_err < o_result_conv.error + err_threshold) {
            rot.setValue(this._rotmatrix);
            int i = 0;
            while (i < 5) {
                this._mat_optimize.modifyMatrix(rot, trans, i_offset.vertex, vertex_2d, 4);
                double err = this.errRate(rot, trans, i_offset.vertex, vertex_2d, 4, vertex_3d);
                if (min_err - err < err_threshold / 2.0) break;
                this._transsolver.solveTransportVector(vertex_3d, trans);
                this._rotmatrix.setValue(rot);
                min_err = err;
                ++i;
            }
            this.updateMatrixValue(this._rotmatrix, trans, o_result_conv);
        } else {
            this._rotmatrix.initRotBySquare(i_square.line, i_square.sqvertex);
            this._rotmatrix.getPoint3dBatch(i_offset.vertex, vertex_3d, 4);
            this._transsolver.solveTransportVector(vertex_3d, trans);
            min_err = this.optimize(this._rotmatrix, trans, this._transsolver, i_offset.vertex, vertex_2d, err_threshold);
            this.updateMatrixValue(this._rotmatrix, trans, o_result_conv);
        }
        o_result_conv.error = min_err;
    }

    private double optimize(NyARRotMatrix io_rotmat, NyARDoublePoint3d io_transvec, INyARTransportVectorSolver i_solver, NyARDoublePoint3d[] i_offset_3d, NyARDoublePoint2d[] i_2d_vertex, double i_err_threshold) throws NyARException {
        NyARDoublePoint3d[] vertex_3d = this.__transMat_vertex_3d;
        double min_err = this.errRate(io_rotmat, io_transvec, i_offset_3d, i_2d_vertex, 4, vertex_3d);
        NyARDoubleMatrix33 rot = this.__rot;
        rot.setValue(io_rotmat);
        int i = 0;
        while (i < 5) {
            this._mat_optimize.modifyMatrix(rot, io_transvec, i_offset_3d, i_2d_vertex, 4);
            double err = this.errRate(rot, io_transvec, i_offset_3d, i_2d_vertex, 4, vertex_3d);
            if (min_err - err < i_err_threshold) break;
            i_solver.solveTransportVector(vertex_3d, io_transvec);
            io_rotmat.setValue(rot);
            min_err = err;
            ++i;
        }
        return min_err;
    }

    public double errRate(NyARDoubleMatrix33 io_rot, NyARDoublePoint3d i_trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d, int i_number_of_vertex, NyARDoublePoint3d[] o_rot_vertex) throws NyARException {
        NyARPerspectiveProjectionMatrix cp = this._projection_mat_ref;
        double cp00 = cp.m00;
        double cp01 = cp.m01;
        double cp02 = cp.m02;
        double cp11 = cp.m11;
        double cp12 = cp.m12;
        double err = 0.0;
        int i = 0;
        while (i < i_number_of_vertex) {
            double z3d;
            double y3d;
            double x3d;
            o_rot_vertex[i].x = x3d = io_rot.m00 * i_vertex3d[i].x + io_rot.m01 * i_vertex3d[i].y + io_rot.m02 * i_vertex3d[i].z;
            o_rot_vertex[i].y = y3d = io_rot.m10 * i_vertex3d[i].x + io_rot.m11 * i_vertex3d[i].y + io_rot.m12 * i_vertex3d[i].z;
            o_rot_vertex[i].z = z3d = io_rot.m20 * i_vertex3d[i].x + io_rot.m21 * i_vertex3d[i].y + io_rot.m22 * i_vertex3d[i].z;
            double x2d = (x3d += i_trans.x) * cp00 + (y3d += i_trans.y) * cp01 + (z3d += i_trans.z) * cp02;
            double y2d = y3d * cp11 + z3d * cp12;
            double h2d = z3d;
            double t1 = i_vertex2d[i].x - x2d / h2d;
            double t2 = i_vertex2d[i].y - y2d / h2d;
            err += t1 * t1 + t2 * t2;
            ++i;
        }
        return err / (double)i_number_of_vertex;
    }

    public void updateMatrixValue(NyARRotMatrix i_rot, NyARDoublePoint3d i_trans, NyARTransMatResult o_result) {
        o_result.m00 = i_rot.m00;
        o_result.m01 = i_rot.m01;
        o_result.m02 = i_rot.m02;
        o_result.m03 = i_trans.x;
        o_result.m10 = i_rot.m10;
        o_result.m11 = i_rot.m11;
        o_result.m12 = i_rot.m12;
        o_result.m13 = i_trans.y;
        o_result.m20 = i_rot.m20;
        o_result.m21 = i_rot.m21;
        o_result.m22 = i_rot.m22;
        o_result.m23 = i_trans.z;
        o_result.has_value = true;
    }
}

