/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.labeling.artoolkit;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingImage;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingLabel;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingLabelStack;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARWorkHolder;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public final class NyARLabeling_ARToolKit {
    private static final int WORK_SIZE = 32768;
    private final NyARWorkHolder work_holder = new NyARWorkHolder(32768);

    public int labeling(NyARBinRaster i_raster, NyARLabelingImage o_destination) throws NyARException {
        NyARLabelingLabel label_pt;
        int[] work2_pt;
        int i;
        assert (i_raster.getBufferType() == 262146);
        NyARIntSize in_size = i_raster.getSize();
        assert (o_destination.getSize().isEqualSize(in_size));
        int lxsize = in_size.w;
        int lysize = in_size.h;
        int[] label_img = (int[])o_destination.getBuffer();
        o_destination.reset(true);
        int[] label_idxtbl = o_destination.getIndexArray();
        int[] raster_buf = (int[])i_raster.getBuffer();
        int wk_max = 0;
        int[][] work2 = this.work_holder.work2;
        int j = 1;
        while (j < lysize - 1) {
            int pixel_index = j * lxsize + 1;
            int label_img_ptr1 = pixel_index - lxsize;
            i = 1;
            while (i < lxsize - 1) {
                if (raster_buf[pixel_index] != 0) {
                    label_img[pixel_index] = 0;
                } else {
                    int label_pixel;
                    if (label_img[label_img_ptr1] > 0) {
                        label_pixel = label_img[label_img_ptr1];
                        work2_pt = work2[label_pixel - 1];
                        work2_pt[0] = work2_pt[0] + 1;
                        work2_pt[1] = work2_pt[1] + i;
                        work2_pt[2] = work2_pt[2] + j;
                        work2_pt[6] = j;
                    } else if (label_img[label_img_ptr1 + 1] > 0) {
                        int k;
                        int n;
                        if (label_img[label_img_ptr1 - 1] > 0) {
                            label_pixel = label_idxtbl[label_img[label_img_ptr1 + 1] - 1];
                            n = label_idxtbl[label_img[label_img_ptr1 - 1] - 1];
                            if (label_pixel > n) {
                                k = 0;
                                while (k < wk_max) {
                                    if (label_idxtbl[k] == label_pixel) {
                                        label_idxtbl[k] = n;
                                    }
                                    ++k;
                                }
                                label_pixel = n;
                            } else if (label_pixel < n) {
                                k = 0;
                                while (k < wk_max) {
                                    if (label_idxtbl[k] == n) {
                                        label_idxtbl[k] = label_pixel;
                                    }
                                    ++k;
                                }
                            }
                            work2_pt = work2[label_pixel - 1];
                            work2_pt[0] = work2_pt[0] + 1;
                            work2_pt[1] = work2_pt[1] + i;
                            work2_pt[2] = work2_pt[2] + j;
                            work2_pt[6] = j;
                        } else if (label_img[pixel_index - 1] > 0) {
                            label_pixel = label_idxtbl[label_img[label_img_ptr1 + 1] - 1];
                            n = label_idxtbl[label_img[pixel_index - 1] - 1];
                            if (label_pixel > n) {
                                k = 0;
                                while (k < wk_max) {
                                    if (label_idxtbl[k] == label_pixel) {
                                        label_idxtbl[k] = n;
                                    }
                                    ++k;
                                }
                                label_pixel = n;
                            } else if (label_pixel < n) {
                                k = 0;
                                while (k < wk_max) {
                                    if (label_idxtbl[k] == n) {
                                        label_idxtbl[k] = label_pixel;
                                    }
                                    ++k;
                                }
                            }
                            work2_pt = work2[label_pixel - 1];
                            work2_pt[0] = work2_pt[0] + 1;
                            work2_pt[1] = work2_pt[1] + i;
                            work2_pt[2] = work2_pt[2] + j;
                        } else {
                            label_pixel = label_img[label_img_ptr1 + 1];
                            work2_pt = work2[label_pixel - 1];
                            work2_pt[0] = work2_pt[0] + 1;
                            work2_pt[1] = work2_pt[1] + i;
                            work2_pt[2] = work2_pt[2] + j;
                            if (work2_pt[3] > i) {
                                work2_pt[3] = i;
                            }
                            work2_pt[6] = j;
                        }
                    } else if (label_img[label_img_ptr1 - 1] > 0) {
                        label_pixel = label_img[label_img_ptr1 - 1];
                        work2_pt = work2[label_pixel - 1];
                        work2_pt[0] = work2_pt[0] + 1;
                        work2_pt[1] = work2_pt[1] + i;
                        work2_pt[2] = work2_pt[2] + j;
                        if (work2_pt[4] < i) {
                            work2_pt[4] = i;
                        }
                        work2_pt[6] = j;
                    } else if (label_img[pixel_index - 1] > 0) {
                        label_pixel = label_img[pixel_index - 1];
                        work2_pt = work2[label_pixel - 1];
                        work2_pt[0] = work2_pt[0] + 1;
                        work2_pt[1] = work2_pt[1] + i;
                        work2_pt[2] = work2_pt[2] + j;
                        if (work2_pt[4] < i) {
                            work2_pt[4] = i;
                        }
                    } else {
                        this.work_holder.reserv(wk_max);
                        label_idxtbl[++wk_max - 1] = wk_max;
                        label_pixel = wk_max;
                        work2_pt = work2[wk_max - 1];
                        work2_pt[0] = 1;
                        work2_pt[1] = i;
                        work2_pt[2] = j;
                        work2_pt[3] = i;
                        work2_pt[4] = i;
                        work2_pt[5] = j;
                        work2_pt[6] = j;
                    }
                    label_img[pixel_index] = label_pixel;
                }
                ++i;
                ++pixel_index;
                ++label_img_ptr1;
            }
            ++j;
        }
        int wlabel_num = 1;
        i = 0;
        while (i < wk_max) {
            label_idxtbl[i] = label_idxtbl[i] == i + 1 ? wlabel_num++ : label_idxtbl[label_idxtbl[i] - 1];
            ++i;
        }
        if (--wlabel_num == 0) {
            o_destination.getLabelStack().clear();
            return 0;
        }
        NyARLabelingLabelStack label_list = o_destination.getLabelStack();
        label_list.init(wlabel_num);
        NyARLabelingLabel[] labels = (NyARLabelingLabel[])label_list.getArray();
        i = 0;
        while (i < wlabel_num) {
            label_pt = labels[i];
            label_pt.id = (short)(i + 1);
            label_pt.area = 0;
            label_pt.pos_y = 0.0;
            label_pt.pos_x = 0.0;
            label_pt.clip_l = lxsize;
            label_pt.clip_t = lysize;
            label_pt.clip_b = 0;
            label_pt.clip_r = 0;
            ++i;
        }
        i = 0;
        while (i < wk_max) {
            label_pt = labels[label_idxtbl[i] - 1];
            work2_pt = work2[i];
            label_pt.area += work2_pt[0];
            label_pt.pos_x += (double)work2_pt[1];
            label_pt.pos_y += (double)work2_pt[2];
            if (label_pt.clip_l > work2_pt[3]) {
                label_pt.clip_l = work2_pt[3];
            }
            if (label_pt.clip_r < work2_pt[4]) {
                label_pt.clip_r = work2_pt[4];
            }
            if (label_pt.clip_t > work2_pt[5]) {
                label_pt.clip_t = work2_pt[5];
            }
            if (label_pt.clip_b < work2_pt[6]) {
                label_pt.clip_b = work2_pt[6];
            }
            ++i;
        }
        i = 0;
        while (i < wlabel_num) {
            label_pt = labels[i];
            label_pt.pos_x /= (double)label_pt.area;
            label_pt.pos_y /= (double)label_pt.area;
            ++i;
        }
        return wlabel_num;
    }
}

