/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.labeling.rlelabeling;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARRleLabelFragmentInfo;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.RleElement;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.RleInfoStack;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public abstract class NyARLabeling_Rle {
    private static final int AR_AREA_MAX = 100000;
    private static final int AR_AREA_MIN = 70;
    private RleInfoStack _rlestack;
    private RleElement[] _rle1;
    private RleElement[] _rle2;
    private int _max_area;
    private int _min_area;
    protected NyARIntSize _raster_size = new NyARIntSize();
    public static final boolean _sf_label_array_safe_reference = true;

    public NyARLabeling_Rle(int i_width, int i_height) throws NyARException {
        this._raster_size.setValue(i_width, i_height);
        this._rlestack = new RleInfoStack(i_width * i_height * 2048 / 76800 + 32);
        this._rle1 = RleElement.createArray(i_width / 2 + 1);
        this._rle2 = RleElement.createArray(i_width / 2 + 1);
        this._max_area = 100000;
        this._min_area = 70;
    }

    public void setAreaRange(int i_max, int i_min) {
        assert (i_min > 0 && i_max > i_min);
        this._max_area = i_max;
        this._min_area = i_min;
    }

    private final int toRel(int[] i_bin_buf, int i_st, int i_len, RleElement[] i_out, int i_th) {
        int current = 0;
        int r = -1;
        int x = i_st;
        int right_edge = i_st + i_len - 1;
        block0: while (x < right_edge) {
            if (i_bin_buf[x] > i_th) {
                ++x;
                continue;
            }
            r = x - i_st;
            i_out[current].l = r++;
            ++x;
            while (x < right_edge) {
                if (i_bin_buf[x] > i_th) {
                    i_out[current].r = r;
                    ++current;
                    ++x;
                    r = -1;
                    continue block0;
                }
                ++r;
                ++x;
            }
        }
        if (i_bin_buf[x] > i_th) {
            if (r >= 0) {
                i_out[current].r = r;
                ++current;
            }
        } else {
            if (r >= 0) {
                i_out[current].r = r + 1;
            } else {
                i_out[current].l = i_len - 1;
                i_out[current].r = i_len;
            }
            ++current;
        }
        return current;
    }

    private final boolean addFragment(RleElement i_rel_img, int i_nof, int i_row_index, RleInfoStack o_stack) throws NyARException {
        int l = i_rel_img.l;
        int len = i_rel_img.r - l;
        i_rel_img.fid = i_nof;
        NyARRleLabelFragmentInfo v = (NyARRleLabelFragmentInfo)o_stack.prePush();
        if (v == null) {
            System.err.println("addFragment force recover!");
            return false;
        }
        v.entry_x = l;
        v.area = len;
        v.clip_l = l;
        v.clip_r = i_rel_img.r - 1;
        v.clip_t = i_row_index;
        v.clip_b = i_row_index;
        v.pos_x = len * (2 * l + (len - 1)) / 2;
        v.pos_y = i_row_index * len;
        return true;
    }

    public void labeling(NyARBinRaster i_bin_raster) throws NyARException {
        assert (i_bin_raster.isEqualBufferType(262146));
        NyARIntSize size = i_bin_raster.getSize();
        this.imple_labeling(i_bin_raster, 0, 0, 0, size.w, size.h);
    }

    public void labeling(NyARBinRaster i_bin_raster, NyARIntRect i_area) throws NyARException {
        assert (i_bin_raster.isEqualBufferType(262146));
        this.imple_labeling(i_bin_raster, 0, i_area.x, i_area.y, i_area.w, i_area.h);
    }

    public void labeling(NyARGrayscaleRaster i_gs_raster, int i_th) throws NyARException {
        assert (i_gs_raster.isEqualBufferType(262145));
        NyARIntSize size = i_gs_raster.getSize();
        this.imple_labeling(i_gs_raster, i_th, 0, 0, size.w, size.h);
    }

    public void labeling(NyARGrayscaleRaster i_gs_raster, NyARIntRect i_area, int i_th) throws NyARException {
        assert (i_gs_raster.isEqualBufferType(262145));
        this.imple_labeling(i_gs_raster, i_th, i_area.x, i_area.y, i_area.w, i_area.h);
    }

    private void imple_labeling(INyARRaster i_raster, int i_th, int i_left, int i_top, int i_width, int i_height) throws NyARException {
        assert (i_raster.getSize().isEqualSize(this._raster_size));
        RleElement[] rle_prev = this._rle1;
        RleElement[] rle_current = this._rle2;
        RleInfoStack rlestack = this._rlestack;
        rlestack.clear();
        int len_prev = 0;
        int len_current = 0;
        int bottom = i_top + i_height;
        int row_stride = this._raster_size.w;
        int[] in_buf = (int[])i_raster.getBuffer();
        int id_max = 0;
        int label_count = 0;
        int rle_top_index = i_left + row_stride * i_top;
        len_prev = this.toRel(in_buf, rle_top_index, i_width, rle_prev, i_th);
        int i = 0;
        while (i < len_prev) {
            if (this.addFragment(rle_prev[i], id_max, i_top, rlestack)) {
                ++id_max;
                ++label_count;
            }
            ++i;
        }
        NyARRleLabelFragmentInfo[] f_array = (NyARRleLabelFragmentInfo[])rlestack.getArray();
        int y = i_top + 1;
        while (y < bottom) {
            len_current = this.toRel(in_buf, rle_top_index += row_stride, i_width, rle_current, i_th);
            int index_prev = 0;
            int i2 = 0;
            while (i2 < len_current) {
                block24: {
                    int id = -1;
                    block3: while (index_prev < len_prev) {
                        if (rle_current[i2].l - rle_prev[index_prev].r > 0) {
                            ++index_prev;
                            continue;
                        }
                        if (rle_prev[index_prev].l - rle_current[i2].r > 0) {
                            if (this.addFragment(rle_current[i2], id_max, y, rlestack)) {
                                ++id_max;
                                ++label_count;
                            }
                            break block24;
                        }
                        id = rle_prev[index_prev].fid;
                        NyARRleLabelFragmentInfo id_ptr = f_array[id];
                        rle_current[i2].fid = id;
                        int l = rle_current[i2].l;
                        int r = rle_current[i2].r;
                        int len = r - l;
                        id_ptr.area += len;
                        id_ptr.clip_l = l < id_ptr.clip_l ? l : id_ptr.clip_l;
                        id_ptr.clip_r = r > id_ptr.clip_r ? r - 1 : id_ptr.clip_r;
                        id_ptr.clip_b = y;
                        id_ptr.pos_x += (double)(len * (2 * l + (len - 1)) / 2);
                        id_ptr.pos_y += (double)(y * len);
                        ++index_prev;
                        while (index_prev < len_prev) {
                            if (rle_current[i2].l - rle_prev[index_prev].r > 0) break block3;
                            if (rle_prev[index_prev].l - rle_current[i2].r > 0) {
                                --index_prev;
                                break block24;
                            }
                            int prev_id = rle_prev[index_prev].fid;
                            NyARRleLabelFragmentInfo prev_ptr = f_array[prev_id];
                            if (id != prev_id) {
                                --label_count;
                                int i22 = index_prev;
                                while (i22 < len_prev) {
                                    if (rle_prev[i22].fid == prev_id) {
                                        rle_prev[i22].fid = id;
                                    }
                                    ++i22;
                                }
                                i22 = 0;
                                while (i22 < i2) {
                                    if (rle_current[i22].fid == prev_id) {
                                        rle_current[i22].fid = id;
                                    }
                                    ++i22;
                                }
                                id_ptr.area += prev_ptr.area;
                                id_ptr.pos_x += prev_ptr.pos_x;
                                id_ptr.pos_y += prev_ptr.pos_y;
                                if (id_ptr.clip_t > prev_ptr.clip_t) {
                                    id_ptr.clip_t = prev_ptr.clip_t;
                                    id_ptr.entry_x = prev_ptr.entry_x;
                                } else if (id_ptr.clip_t >= prev_ptr.clip_t && id_ptr.entry_x > prev_ptr.entry_x) {
                                    id_ptr.entry_x = prev_ptr.entry_x;
                                }
                                if (id_ptr.clip_l > prev_ptr.clip_l) {
                                    id_ptr.clip_l = prev_ptr.clip_l;
                                }
                                if (id_ptr.clip_r < prev_ptr.clip_r) {
                                    id_ptr.clip_r = prev_ptr.clip_r;
                                }
                                prev_ptr.area = 0;
                            }
                            ++index_prev;
                        }
                        --index_prev;
                        break;
                    }
                    if (id < 0 && this.addFragment(rle_current[i2], id_max, y, rlestack)) {
                        ++id_max;
                        ++label_count;
                    }
                }
                ++i2;
            }
            RleElement[] tmp = rle_prev;
            rle_prev = rle_current;
            len_prev = len_current;
            rle_current = tmp;
            ++y;
        }
        int max = this._max_area;
        int min = this._min_area;
        int i3 = id_max - 1;
        while (i3 >= 0) {
            NyARRleLabelFragmentInfo src_info = f_array[i3];
            int area = src_info.area;
            if (area >= min && area <= max) {
                src_info.clip_l += i_left;
                src_info.clip_r += i_left;
                src_info.entry_x += i_left;
                src_info.pos_x /= (double)area;
                src_info.pos_y /= (double)area;
                this.onLabelFound(src_info);
            }
            --i3;
        }
    }

    protected abstract void onLabelFound(NyARRleLabelFragmentInfo var1) throws NyARException;
}

