/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterdriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARHistogramFromRaster;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class NyARHistogramFromRaster_AnyRgb
implements INyARHistogramFromRaster {
    private INyARRgbRaster _gsr;
    private int[] tmp = new int[3];

    public NyARHistogramFromRaster_AnyRgb(INyARRgbRaster i_raster) {
        this._gsr = i_raster;
    }

    @Override
    public void createHistogram(int i_skip, NyARHistogram o_histogram) throws NyARException {
        NyARIntSize s = this._gsr.getSize();
        this.createHistogram(0, 0, s.w, s.h, i_skip, o_histogram);
    }

    @Override
    public void createHistogram(int i_l, int i_t, int i_w, int i_h, int i_skip, NyARHistogram o_histogram) throws NyARException {
        o_histogram.reset();
        int[] data_ptr = o_histogram.data;
        INyARRgbPixelDriver drv = this._gsr.getRgbPixelDriver();
        int pix_count = i_w;
        int pix_mod_part = pix_count - pix_count % 8;
        int y = i_h - 1;
        while (y >= 0) {
            int x = pix_count - 1;
            while (x >= pix_mod_part) {
                drv.getPixel(x, y, this.tmp);
                int n = (this.tmp[0] + this.tmp[1] + this.tmp[2]) / 3;
                data_ptr[n] = data_ptr[n] + 1;
                --x;
            }
            y -= i_skip;
        }
        o_histogram.total_of_data = i_w * i_h / i_skip;
    }
}

