/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.utils;

import jp.nyatla.nyartoolkit.NyARException;

public abstract class NyObjectStack {
    private static final int ARRAY_APPEND_STEP = 64;
    protected final Object[] _items;
    private int _allocated_size;
    protected int _length;

    protected NyObjectStack(Object[] i_array) {
        this._items = i_array;
        this._allocated_size = 0;
        this._length = 0;
    }

    public final Object prePush() throws NyARException {
        if (this._length >= this._allocated_size) {
            if (this._length >= this._items.length) {
                throw new NyARException();
            }
            int range = this._length + 64;
            if (range >= this._items.length) {
                range = this._items.length;
            }
            this.onReservRequest(this._allocated_size, range, this._items);
            this._allocated_size = range;
        }
        Object ret = this._items[this._length];
        ++this._length;
        return ret;
    }

    public final Object pop() throws NyARException {
        if (this._length < 1) {
            throw new NyARException();
        }
        --this._length;
        return this.getItem(this._length);
    }

    public final void reserv(int i_number_of_item) throws NyARException {
        if (i_number_of_item >= this._allocated_size) {
            if (i_number_of_item >= this._items.length) {
                throw new NyARException();
            }
            int range = i_number_of_item + 64;
            if (range >= this._items.length) {
                range = this._items.length;
            }
            this.onReservRequest(this._allocated_size, range, this._items);
            this._allocated_size = range;
        }
        this._length = i_number_of_item;
    }

    protected abstract void onReservRequest(int var1, int var2, Object[] var3);

    public final Object[] getArray() {
        return this._items;
    }

    public final Object getItem(int i_index) {
        return this._items[i_index];
    }

    public final int getLength() {
        return this._length;
    }

    public final void clear() {
        this._length = 0;
    }
}

