/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.INyARSquareDetector;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARSquareDetector;
import jp.nyatla.nyartoolkit.core.NyARSquareStack;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_O3;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.NyARRasterFilter_ARToolkitThreshold;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.detector.NyARDetectMarkerResult;
import jp.nyatla.nyartoolkit.detector.NyARDetectMarkerResultHolder;

public class NyARDetectMarker {
    private static final int AR_SQUARE_MAX = 300;
    private boolean _is_continue = false;
    private NyARMatchPatt_Color_WITHOUT_PCA _match_patt;
    private INyARSquareDetector _square_detect;
    private final NyARSquareStack _square_list = new NyARSquareStack(300);
    private NyARCode[] _codes;
    protected INyARTransMat _transmat;
    private double[] _marker_width;
    private int _number_of_code;
    private INyARColorPatt _patt;
    private NyARDetectMarkerResultHolder _result_holder = new NyARDetectMarkerResultHolder();
    private NyARBinRaster _bin_raster;
    private NyARRasterFilter_ARToolkitThreshold _tobin_filter = new NyARRasterFilter_ARToolkitThreshold(100);

    public NyARDetectMarker(NyARParam i_param, NyARCode[] i_code, double[] i_marker_width, int i_number_of_code) throws NyARException {
        NyARIntSize scr_size = i_param.getScreenSize();
        this._square_detect = new NyARSquareDetector(i_param.getDistortionFactor(), scr_size);
        this._transmat = new NyARTransMat(i_param);
        this._codes = i_code;
        int cw = i_code[0].getWidth();
        int ch = i_code[0].getHeight();
        int i = 1;
        while (i < i_number_of_code) {
            if (cw != i_code[i].getWidth() || ch != i_code[i].getHeight()) {
                throw new NyARException();
            }
            ++i;
        }
        this._patt = new NyARColorPatt_O3(cw, ch);
        this._number_of_code = i_number_of_code;
        this._marker_width = i_marker_width;
        this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA();
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
    }

    public int detectMarkerLite(INyARRgbRaster i_raster, int i_threshold) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize())) {
            throw new NyARException();
        }
        this._tobin_filter.setThreshold(i_threshold);
        this._tobin_filter.doFilter(i_raster, this._bin_raster);
        NyARSquareStack l_square_list = this._square_list;
        this._square_detect.detectMarker(this._bin_raster, l_square_list);
        int number_of_square = l_square_list.getLength();
        if (number_of_square < 1) {
            return 0;
        }
        this._result_holder.reservHolder(number_of_square);
        int i = 0;
        while (i < number_of_square) {
            NyARSquare square = (NyARSquare)l_square_list.getItem(i);
            if (this._patt.pickFromRaster(i_raster, square)) {
                if (!this._match_patt.setPatt(this._patt)) {
                    throw new NyARException();
                }
                int code_index = 0;
                this._match_patt.evaluate(this._codes[0]);
                double confidence = this._match_patt.getConfidence();
                int direction = this._match_patt.getDirection();
                int i2 = 1;
                while (i2 < this._number_of_code) {
                    this._match_patt.evaluate(this._codes[i2]);
                    double c2 = this._match_patt.getConfidence();
                    if (!(confidence > c2)) {
                        code_index = i2;
                        direction = this._match_patt.getDirection();
                        confidence = c2;
                    }
                    ++i2;
                }
                NyARDetectMarkerResult result = this._result_holder.result_array[i];
                result.arcode_id = code_index;
                result.confidence = confidence;
                result.direction = direction;
                result.ref_square = square;
            }
            ++i;
        }
        return number_of_square;
    }

    public void getTransmationMatrix(int i_index, NyARTransMatResult o_result) throws NyARException {
        NyARDetectMarkerResult result = this._result_holder.result_array[i_index];
        if (this._is_continue) {
            this._transmat.transMatContinue(result.ref_square, result.direction, this._marker_width[result.arcode_id], o_result);
        } else {
            this._transmat.transMat(result.ref_square, result.direction, this._marker_width[result.arcode_id], o_result);
        }
    }

    public double getConfidence(int i_index) {
        return this._result_holder.result_array[i_index].confidence;
    }

    public int getDirection(int i_index) {
        return this._result_holder.result_array[i_index].direction;
    }

    public int getARCodeIndex(int i_index) {
        return this._result_holder.result_array[i_index].arcode_id;
    }

    public void setContinueMode(boolean i_is_continue) {
        this._is_continue = i_is_continue;
    }
}

