/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.analyzer.histogram;

import jp.nyatla.nyartoolkit.core.analyzer.histogram.INyARHistogramAnalyzer_Threshold;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;

public class NyARHistogramAnalyzer_DiscriminantThreshold
implements INyARHistogramAnalyzer_Threshold {
    private double _score;

    @Override
    public int getThreshold(NyARHistogram i_histogram) {
        int[] hist = i_histogram.data;
        int n = i_histogram.length;
        int th = 0;
        int pt = 0;
        int dt = 0;
        int i = 0;
        while (i < n) {
            int h = hist[i];
            dt += h * i;
            pt += h * i * i;
            ++i;
        }
        int st = i_histogram.total_of_data;
        int da = dt;
        int sa = st;
        int sb = 0;
        int db = 0;
        double max = -1.0;
        double max_mt = 0.0;
        i = n - 1;
        while (i > 0) {
            double mb;
            double dv;
            int hist_count;
            int hist_val;
            double mt;
            double ma = (sa != 0 ? (double)da / (double)sa : 0.0) - (mt = (double)((da -= (hist_val = (hist_count = hist[i]) * i)) + (db += hist_val)) / (dv = (double)((sa -= hist_count) + (sb += hist_count))));
            double kai = ((double)sa * (ma * ma) + (double)sb * ((mb = (sb != 0 ? (double)db / (double)sb : 0.0) - mt) * mb)) / dv;
            if (max < kai) {
                max_mt = mt;
                max = kai;
                th = i;
            }
            --i;
        }
        this._score = max / (((double)pt + max_mt * max_mt * (double)st - 2.0 * max_mt * (double)dt) / (double)st);
        return th;
    }

    public final double getLastScore() {
        return this._score;
    }

    public static void main(String[] args) {
        NyARHistogram data = new NyARHistogram(256);
        int i = 0;
        while (i < 256) {
            data.data[i] = 128 - i > 0 ? 128 - i : i - 128;
            ++i;
        }
        data.total_of_data = data.getTotal(0, 255);
        NyARHistogramAnalyzer_DiscriminantThreshold an = new NyARHistogramAnalyzer_DiscriminantThreshold();
        int th = an.getThreshold(data);
        System.out.print(th);
    }
}

