/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingLabel;

class OverlapChecker {
    private NyARLabelingLabel[] _labels = new NyARLabelingLabel[32];
    private int _length;

    OverlapChecker() {
    }

    public void reset(int i_max_label) {
        if (i_max_label > this._labels.length) {
            this._labels = new NyARLabelingLabel[i_max_label];
        }
        this._length = 0;
    }

    public void push(NyARLabelingLabel i_label_ref) {
        this._labels[this._length] = i_label_ref;
        ++this._length;
    }

    public boolean check(NyARLabelingLabel i_label) {
        NyARLabelingLabel[] label_pt = this._labels;
        int px1 = (int)i_label.pos_x;
        int py1 = (int)i_label.pos_y;
        int i = this._length - 1;
        while (i >= 0) {
            int px2 = (int)label_pt[i].pos_x;
            int py2 = (int)label_pt[i].pos_y;
            int d = (px1 - px2) * (px1 - px2) + (py1 - py2) * (py1 - py2);
            if (d < label_pt[i].area / 4) {
                return false;
            }
            --i;
        }
        return true;
    }
}

