// NyWin32CaptureTestDlg.cpp : t@C
//

#include "stdafx.h"
#include <assert.h>
#include "NyWin32Capture.h"
#include "NyWin32CaptureTest.h"
#include "NyWin32CaptureTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


using namespace NyWin32Capture;

/*	AvP[VRg[
*/
class AppCtrl
{
public:
	CWnd* _wnd;
	CaptureDeviceList* devlist;
	CaptureDevice* dev;
	BITMAPINFOHEADER dibheader;
public:
	AppCtrl(CWnd* i_app_window)
	{
		CoInitialize(NULL);

		this->_wnd=i_app_window;
		CButton* bn=(CButton*)_wnd->GetDlgItem(ID_SWITCH);
		bn->SetWindowText(_T("start capture"));
		//JLv`foCX̃XgB
		devlist=new CaptureDeviceList();
		//Lv`foCX̃Xg1Ԗڂ̃J𓾂B
		int nod=this->devlist->getNumberOfDevice();
		if(nod<1){
			throw std::exception("This computer has not Capture device.");
		}
		//0Ԗڂ̃JB
		CaptureDevice* d=devlist->getDevice(0);
		d->openDevice();
		//Lv`tH[}bgݒ
		SetupCaptureFormat(d,this->dibheader);
		//R[obN[h̎Ɏg[U`lݒ
		d->setUserValue(this);
		this->dev=d;

	}
	virtual ~AppCtrl()
	{
		delete devlist;
		//JLv`foCX̃XgJ
		CoUninitialize();


	}
	//PԖڂ̃JQVGAŃLv`ł悤ɐݒ肷B
	bool SetupCaptureFormat(CaptureDevice* d,BITMAPINFOHEADER& bmiheader)
	{
		//tH[}bgXg𓾂B
		VideoFormatList lt;
		d->getVideoFormatList(lt);
		int nof=lt.getNumberOfFormat();
		if(nof<1){
			return "The device has not Video format.";
		}
		//C[W̃tH[}bgݒB̃^Cvuuids.hɏĂB
		const VideoFormat* vf=lt.getFormat(320,240,MEDIASUBTYPE_RGB24);
		if(vf==NULL){
			//JtH[}bgĂȂꍇ̓CeWFgڑB
			d->setVideoFormat(320,240,MEDIASUBTYPE_RGB24,30.0);
			VideoFormat::initBITMAPINFOHEADER(320,240,MEDIASUBTYPE_RGB24,bmiheader);
		}else{
			//JtH[}bgĂꍇ͂̂܂܎g
			d->setVideoFormat(*vf,30.0);
			bmiheader=*(vf->getBitmapInfoHeader());
		}
		return true;
	}
	//ăC[W擾āAEChEɕ`
	void DrawBitmap()
	{
		//C[W𓯊擾
		const AM_MEDIA_TYPE& mt=dev->getMediaType();
		BYTE* buf;
		buf=new BYTE[mt.lSampleSize];
		this->dev->captureImage(buf);
		//`
		DrawBitmap(buf);
		delete[] buf;
	}
	//data̓eEChEɕ`
	void DrawBitmap(void* data)
	{
		//DIBBITMAPɕϊĕ`
		CDC* dc=this->_wnd->GetDC();
		CBitmap bmp;
		BITMAPINFO bmi;
		bmi.bmiHeader=this->dibheader;
		int l=SetDIBitsToDevice(
			dc->m_hDC,0,0,this->dibheader.biWidth,this->dibheader.biHeight,
			0,0,0,this->dibheader.biHeight,data,&bmi,DIB_RGB_COLORS);
		this->_wnd->ReleaseDC(dc);
	}
	void Start(bool is_async)
	{
		if(!is_async){
			this->dev->startCapture();	//擾̎Ȃ炱
		}else{
			this->dev->startCaptureCallback(AppCtrl::OnCaptureImage);		//񓯊擾̎Ȃ炱
		}
	}
	void Stop()
	{
		this->dev->stopCapture();
	}
	static void OnCaptureImage(const CaptureDevice* i_sender,BYTE *pBuffer, long BufferLen)
	{
		//SendMessageŔ΂
		AppCtrl* inst=(AppCtrl*)(i_sender->getUserValue());
		DWORD ret;
		//GDIƓƂƂɃfbgbN\邩B
		if(SendMessageTimeout(inst->_wnd->m_hWnd,WM_USER+39,0,(LPARAM)pBuffer,SMTO_ABORTIFHUNG,1000,&ret)==0){
			OutputDebugString(_T("Error on SendMessageTimeout"));
		}
	}
};


//NXJȂ̂ŃO[oϐɂĂ邯ǁAۂ
//eNX̃oɂ悢łB
AppCtrl* appctrl;




// CNyWin32CaptureTestDlg _CAO




CNyWin32CaptureTestDlg::CNyWin32CaptureTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNyWin32CaptureTestDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNyWin32CaptureTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CNyWin32CaptureTestDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(ID_SWITCH, &CNyWin32CaptureTestDlg::OnBnClickedSwitch)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_WM_TIMER()
    ON_MESSAGE((WM_USER+39),CNyWin32CaptureTestDlg::OnASyncCapture)//Lv`
END_MESSAGE_MAP()


// CNyWin32CaptureTestDlg bZ[W nh

BOOL CNyWin32CaptureTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	this->is_start=false;

	appctrl=new AppCtrl(this);

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CNyWin32CaptureTestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);

	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CNyWin32CaptureTestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



//{^ꂽƂ
void CNyWin32CaptureTestDlg::OnBnClickedSwitch()
{
	//Lv`ONOFF̐؂ւ
	CButton* bn=(CButton*)this->GetDlgItem(ID_SWITCH);
	this->is_start=(!this->is_start);
	bn->SetWindowText(this->is_start?_T("stop capture"):_T("start capture"));
/*	//seXg
	if(this->is_start){
		appctrl->Start(false);
		this->SetTimer(123,100,NULL);
	}else{
		this->KillTimer(123);
		appctrl->Stop();
	}*/
	//񓯊Ȃ炱
	if(this->is_start){
		appctrl->Start(true);
	}else{
		appctrl->Stop();
	}
}

void CNyWin32CaptureTestDlg::OnClose()
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CDialog::OnClose();
}

void CNyWin32CaptureTestDlg::OnDestroy()
{
	delete appctrl;
	CDialog::OnDestroy();
	// TODO: ɃbZ[W nh R[hǉ܂B
}

void CNyWin32CaptureTestDlg::OnTimer(UINT_PTR nIDEvent)
{
	appctrl->DrawBitmap();
	CDialog::OnTimer(nIDEvent);
}
//SendMessageŔ΂bZ[W̎󂯌
LRESULT CNyWin32CaptureTestDlg::OnASyncCapture(WPARAM wParam, LPARAM lParam )
{
	//[64bit|C^Ƃ܂ȂH
	appctrl->DrawBitmap((void*)lParam);
	return 0;
}
