/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2004-2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	Tv^[QbgˑVXe^C}W[iLEGO MINDSTORMS NXTpj
 */


#include "kernel.h"

/* LEJOS NXJ */
#include "AT91SAM7.h"
#include "systick.h"

#include "ecrobot_base.h"
#include "ecrobot_interface.h"

/* Originally, systick_low_priority_C is a LEJOS ISR. 
 * LEJOS-OSEK uses systick_isr_C1 category 2 ISR instead of systick_low_priority_C 
 * to implement a system timer module for OSEK alarm and 
 * check the buttons status to shutdown the system
 */
extern void systick_low_priority_C(void);

void systick_isr_C1()
{
	/* clear the interrupt status register (2007/12/27) */
	*AT91C_AIC_ICCR = (1 << 10); /* 10 = LOW_PRIORITY_IRQ */

	/* check OSEK was started */ 
	if (get_OS_flag())
	{
		user_1ms_isr_type2();
		check_NXT_buttons();
	}

	/* this function should be here to stop the NXT immediately 
	 * after EXIT button was pressed
	 */
	systick_low_priority_C();

}

